/*
 * Decompiled with CFR 0.152.
 */
package com.mazepeng.codec;

public class IntegerUtils {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] MIN_VALUE_BYTES = "-9223372036854775808".getBytes();

    public static int longToBytes(long value, byte[] buffer, int offset) {
        boolean negative;
        int i;
        if (value == 0L) {
            buffer[offset] = 48;
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            System.arraycopy(MIN_VALUE_BYTES, 0, buffer, offset, MIN_VALUE_BYTES.length);
            return MIN_VALUE_BYTES.length;
        }
        int start = i = offset + 20;
        long n = value;
        boolean bl = negative = n < 0L;
        if (negative) {
            n = -n;
        }
        while (n > 0L) {
            buffer[--i] = DIGITS[(int)(n % 10L)];
            n /= 10L;
        }
        if (negative) {
            buffer[--i] = 45;
        }
        int len = start - i;
        System.arraycopy(buffer, i, buffer, offset, len);
        return len;
    }
}

