/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.ListApiClient;
import com.mediumapi.domain.list.MediumList;
import com.mediumapi.domain.list.MediumListArticles;
import com.mediumapi.domain.list.MediumListResponses;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface ListApi {
    default public ListApiClient getDelegate() {
        return new ListApiClient(){};
    }

    @Operation(operationId="listListIdArticlesGet", summary="Get List Articles", description="Returns an array of `articles_ids` present in the given Medium List. ", tags={"List"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumListArticles.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/list/{list_id}/articles"}, produces={"application/json"})
    default public ResponseEntity<MediumListArticles> listListIdArticlesGet(@Parameter(name="list_id", description="It's a unique hash id assigned to every Medium List.", required=true, in=ParameterIn.PATH) @PathVariable(value="list_id") String listId) {
        return this.getDelegate().listListIdArticlesGet(listId);
    }

    @Operation(operationId="listListIdGet", summary="Get List Info", description="Returns the list-related information such as *id, name, author, description,  thumbnail image url, creation datetime, last article inserted datetime,  number of articles in the list, claps, voters, and comments/responses*. ", tags={"List"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumList.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/list/{list_id}"}, produces={"application/json"})
    default public ResponseEntity<MediumList> listListIdGet(@Parameter(name="list_id", description="It's a unique hash id assigned to every Medium List.", required=true, in=ParameterIn.PATH) @PathVariable(value="list_id") String listId) {
        return this.getDelegate().listListIdGet(listId);
    }

    @Operation(operationId="listListIdResponsesGet", summary="Get List Responses", description="Returns an array of `response_ids` of the comments (same as `article_ids`) on the given Medium List. ", tags={"List"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumListResponses.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/list/{list_id}/responses"}, produces={"application/json"})
    default public ResponseEntity<MediumListResponses> listListIdResponsesGet(@Parameter(name="list_id", description="It's a unique hash id assigned to every Medium List.", required=true, in=ParameterIn.PATH) @PathVariable(value="list_id") String listId) {
        return this.getDelegate().listListIdResponsesGet(listId);
    }
}

