/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.ArticleApiClient;
import com.mediumapi.domain.article.MediumArticle;
import com.mediumapi.domain.article.MediumArticleAssets;
import com.mediumapi.domain.article.MediumArticleContent;
import com.mediumapi.domain.article.MediumArticleFans;
import com.mediumapi.domain.article.MediumArticleHTML;
import com.mediumapi.domain.article.MediumArticleMarkdown;
import com.mediumapi.domain.article.MediumArticleRecommended;
import com.mediumapi.domain.article.MediumArticleRelated;
import com.mediumapi.domain.article.MediumArticleResponses;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface ArticleApi {
    default public ArticleApiClient getDelegate() {
        return new ArticleApiClient(){};
    }

    @Operation(operationId="articleArticleIdAssetsGet", summary="Get Article Assets", description="Returns a list of URLs for the assets present in the Medium Article.  These assets may include images, embedded YouTube videos, Github Gists, Hyperlinks (anchors), Links to other Medium Articles, etc\u2026 ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleAssets.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/assets"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleAssets> articleArticleIdAssetsGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdAssetsGet(articleId);
    }

    @Operation(operationId="articleArticleIdContentGet", summary="Get Article's Content", description="Returns the content of an article for the given `article_id`. ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleContent.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/content"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleContent> articleArticleIdContentGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdContentGet(articleId);
    }

    @Operation(operationId="articleArticleIdFansGet", summary="Get Article Fans", description="Returns a list of `user_ids` of the people who clapped on the article (a.k.a `voters`). ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleFans.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/fans"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleFans> articleArticleIdFansGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdFansGet(articleId);
    }

    @Operation(operationId="articleArticleIdGet", summary="Get Article Info", description="Returns article-related information such as  - Title - Subtitle - Author (ID) - Tags - Topics (assigned by Medium) - Publication (ID) - Published date and time - Last Modified date and time - Clap Count - Voter Count - Word Count - Response Count - Reading Time - Language - Unique Slug - URL - Image URL (Cover image) - Top Highlight - Whether the article is in a series or not (boolean) - Whether the article is a shortform or not (boolean) - Whether the article is locked or not (boolean) ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticle.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}"}, produces={"application/json"})
    default public ResponseEntity<MediumArticle> articleArticleIdGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdGet(articleId);
    }

    @Operation(operationId="articleArticleIdHtmlGet", summary="Get Article's HTML", description="Returns the **plain HTML** of a Medium Article, for the given `article_id`.  **Note:** This plain HTML output can be stylized as per your own custom branding. For the sample CSS, visit: \"https://mediumapi.com/styles/dark.css\" ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleHTML.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/html"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleHTML> articleArticleIdHtmlGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId, @Parameter(name="fullpage", description="If 'true', returns full HTML page with head, body, title and meta tags. Else, returns HTML inside body only.", in=ParameterIn.QUERY) @Valid @RequestParam(value="fullpage", required=false) Boolean fullpage, @Parameter(name="style_file", description="Name or link to a CSS file to be included in the HTML. It works when `fullpage` is true.", in=ParameterIn.QUERY) @Valid @RequestParam(value="style_file", required=false) String styleFile) {
        return this.getDelegate().articleArticleIdHtmlGet(articleId, fullpage, styleFile);
    }

    @Operation(operationId="articleArticleIdMarkdownGet", summary="Get Article's Markdown", description="Returns the markdown of a Medium Article/Story, for the given `article_id` ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleMarkdown.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/markdown"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleMarkdown> articleArticleIdMarkdownGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdMarkdownGet(articleId);
    }

    @Operation(operationId="articleArticleIdRecommendedGet", summary="Get Recommended Articles", description="Returns a list of 10 articles (`article_ids`) as recommended by the Medium, for the given article. ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleRecommended.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/recommended"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleRecommended> articleArticleIdRecommendedGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdRecommendedGet(articleId);
    }

    @Operation(operationId="articleArticleIdRelatedGet", summary="Get Related Articles", description="Returns a list of `article_ids` of the related posts. (Length = 4) ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleRelated.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/related"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleRelated> articleArticleIdRelatedGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdRelatedGet(articleId);
    }

    @Operation(operationId="articleArticleIdResponsesGet", summary="Get Article Responses", description="Returns a list of responses (`response_ids`, same as `article_ids`) for a given article (`article_id`)  **Note:** To see the content of the response, use the _Get Article's Content_ endpoint (`/article/{article_id}/content`) ", tags={"Article"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumArticleResponses.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/article/{article_id}/responses"}, produces={"application/json"})
    default public ResponseEntity<MediumArticleResponses> articleArticleIdResponsesGet(@Parameter(name="article_id", description="It's a unique hash id assigned to every Medium Article.", required=true, in=ParameterIn.PATH) @PathVariable(value="article_id") String articleId) {
        return this.getDelegate().articleArticleIdResponsesGet(articleId);
    }
}

