/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.PlatformApiClient;
import com.mediumapi.domain.platform.MediumPlatformLatestPosts;
import com.mediumapi.domain.platform.MediumPlatformRecommendedFeed;
import com.mediumapi.domain.platform.MediumPlatformRelatedTags;
import com.mediumapi.domain.platform.MediumPlatformTag;
import com.mediumapi.domain.platform.MediumPlatformTopWriters;
import com.mediumapi.domain.platform.MediumPlatformTopfeeds;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface PlatformApi {
    default public PlatformApiClient getDelegate() {
        return new PlatformApiClient(){};
    }

    @Operation(operationId="latestpostsTopicSlugGet", summary="Get Latest Posts", description="Returns a list of latest posts (`article_ids`) for a topic/niche (as classified by the Medium platform). Example of a topic/niche can be: * blockchain * relationships * mental-health, etc \u2026 These are known as `topic_slugs`. At any given moment, this endpoint will return a list of 25 articles (`article_ids`). ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformLatestPosts.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/latestposts/{topic_slug}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformLatestPosts> latestpostsTopicSlugGet(@Parameter(name="topic_slug", description="It's a unique string, usually hyphen-separated, representing a topic/niche, as classified by Medium.", required=true, in=ParameterIn.PATH) @PathVariable(value="topic_slug") String topicSlug) {
        return this.getDelegate().latestpostsTopicSlugGet(topicSlug);
    }

    @Operation(operationId="recommendedFeedTagGet", summary="Get Recommended Feed", description="Returns a list of recommended articles (`article_ids`) for the given `tag`.  This feed is similar to Topfeeds Trending Articles. Using the `page` query string parameter, you can get the list page by page.  The page number can be between 1 and 20. Each page will have up to 25 Article IDs. So at maximum, you can fetch 500 `article_ids` in 20 API calls. ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformRecommendedFeed.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/recommended_feed/{tag}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformRecommendedFeed> recommendedFeedTagGet(@Parameter(name="tag", description="It's a unique string, usually hyphen-separated, representing a class of content.", required=true, in=ParameterIn.PATH) @PathVariable(value="tag") String tag, @Parameter(name="page", description="A number between 1 and 20.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page", required=false) Integer page) {
        return this.getDelegate().recommendedFeedTagGet(tag, page);
    }

    @Operation(operationId="relatedTagsTagGet", summary="Get Related Tags", description="Returns a list of `related_tags` for the given `tag`. ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformRelatedTags.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/related_tags/{tag}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformRelatedTags> relatedTagsTagGet(@Parameter(name="tag", description="It's a unique string, usually hyphen-separated, representing a class of content.", required=true, in=ParameterIn.PATH) @PathVariable(value="tag") String tag) {
        return this.getDelegate().relatedTagsTagGet(tag);
    }

    @Operation(operationId="tagTagGet", summary="Get Tag Info", description="Returns tag-related information. - Name - Followers Count - Number of stories - Number of writers - Number of latest stories - Number of latest writers ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformTag.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/tag/{tag}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformTag> tagTagGet(@Parameter(name="tag", description="It's a unique string, usually hyphen-separated, representing a class of content.", required=true, in=ParameterIn.PATH) @PathVariable(value="tag") String tag) {
        return this.getDelegate().tagTagGet(tag);
    }

    @Operation(operationId="topWritersTopicSlugGet", summary="Get Top Writers", description="Returns a list of top writers (`user_ids`) within a particular topic/niche (`topic_slug`).  e.g.  - blockchain - relationships - artificial-intelligence, etc ... **Note:** You can use optional `count` query parameter to limit the number of results.  The maximum number of top writers within a topic/niche will be 250. ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformTopWriters.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/top_writers/{topic_slug}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformTopWriters> topWritersTopicSlugGet(@Parameter(name="topic_slug", description="It's a unique string, usually hyphen-separated, representing a topic/niche, as classified by Medium.", required=true, in=ParameterIn.PATH) @PathVariable(value="topic_slug") String topicSlug, @Parameter(name="count", description="Limits the number of `article_ids` in the result.", in=ParameterIn.QUERY) @Valid @RequestParam(value="count", required=false) Integer count) {
        return this.getDelegate().topWritersTopicSlugGet(topicSlug, count);
    }

    @Operation(operationId="topfeedsTagModeGet", summary="Get Topfeeds", description="Returns a list of `article_ids` (length: 25) for the given `tag` and `mode`. ", tags={"Platform"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPlatformTopfeeds.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/topfeeds/{tag}/{mode}"}, produces={"application/json"})
    default public ResponseEntity<MediumPlatformTopfeeds> topfeedsTagModeGet(@Parameter(name="tag", description="It's a unique string, usually hyphen-separated, representing a class of content.", required=true, in=ParameterIn.PATH) @PathVariable(value="tag") String tag, @Parameter(name="mode", description="Mode:   - `hot` : For getting trending articles   - `new` : For getting latest articles   - `top_year` : For getting best articles of the year   - `top_month` : For getting best articles of the month   - `top_week` : For getting best articles of the week   - `top_all_time`: For getting best article of all time ", required=true, in=ParameterIn.PATH) @PathVariable(value="mode") String mode) {
        return this.getDelegate().topfeedsTagModeGet(tag, mode);
    }
}

