/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.PublicationApiClient;
import com.mediumapi.domain.publication.MediumPublication;
import com.mediumapi.domain.publication.MediumPublicationArticles;
import com.mediumapi.domain.publication.MediumPublicationID;
import com.mediumapi.domain.publication.MediumPublicationNewsletter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface PublicationApi {
    default public PublicationApiClient getDelegate() {
        return new PublicationApiClient(){};
    }

    @Operation(operationId="publicationIdForPublicationSlugGet", summary="Get Publication ID", description="Returns the unique `publication_id` for the given `publication_slug`.  **Note:** You can find the `publication_slug` from the publication's homepage URL. - medium.com/_**publication_slug** ", tags={"Publication"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPublicationID.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/publication/id_for/{publication_slug}"}, produces={"application/json"})
    default public ResponseEntity<MediumPublicationID> publicationIdForPublicationSlugGet(@Parameter(name="publication_slug", description="It's a lowercased hyphen-separated unique string alloted to each Medium Publication.", required=true, in=ParameterIn.PATH) @PathVariable(value="publication_slug") String publicationSlug) {
        return this.getDelegate().publicationIdForPublicationSlugGet(publicationSlug);
    }

    @Operation(operationId="publicationPublicationIdArticlesGet", summary="Get Publication Articles", description="Returns the list of `articles_ids`, of the latest 25 articles, posted in that publication. ", tags={"Publication"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPublicationArticles.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/publication/{publication_id}/articles"}, produces={"application/json"})
    default public ResponseEntity<MediumPublicationArticles> publicationPublicationIdArticlesGet(@Parameter(name="publication_id", description="It's a unique hash id assigned to every Medium Publication.", required=true, in=ParameterIn.PATH) @PathVariable(value="publication_id") String publicationId, @Parameter(name="from", description="To get the articles before specified date and time.", in=ParameterIn.QUERY) @Valid @RequestParam(value="from", required=false) String from) {
        return this.getDelegate().publicationPublicationIdArticlesGet(publicationId, from);
    }

    @Operation(operationId="publicationPublicationIdGet", summary="Get Publication Info", description="Returns the publication related information such as *Publication name, Tagline, Description, Tags, Followers Count, Twitter username, Instagram username, Facebook Page name, etc \u2026*  **Note:** If you don't know the `publication_id`, you can get it from any article published by it. Use endpoint \"/article/{article_id}\" to retrieve the `publication_id`. ", tags={"Publication"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPublication.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/publication/{publication_id}"}, produces={"application/json"})
    default public ResponseEntity<MediumPublication> publicationPublicationIdGet(@Parameter(name="publication_id", description="It's a unique hash id assigned to every Medium Publication.", required=true, in=ParameterIn.PATH) @PathVariable(value="publication_id") String publicationId) {
        return this.getDelegate().publicationPublicationIdGet(publicationId);
    }

    @Operation(operationId="publicationPublicationIdNewsletterGet", summary="Get Publication Newsletter", description="Returns the newsletter related information such as *id, name, description, slug, creator_id, subscribers, image_url, etc \u2026*  **Note:** If you don't know the `publication_id`, you can get it from any article published by it. Use endpoint \"/article/{article_id}\" to retrieve the `publication_id`. ", tags={"Publication"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumPublicationNewsletter.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/publication/{publication_id}/newsletter"}, produces={"application/json"})
    default public ResponseEntity<MediumPublicationNewsletter> publicationPublicationIdNewsletterGet(@Parameter(name="publication_id", description="It's a unique hash id assigned to every Medium Publication.", required=true, in=ParameterIn.PATH) @PathVariable(value="publication_id") String publicationId) {
        return this.getDelegate().publicationPublicationIdNewsletterGet(publicationId);
    }
}

