/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.SearchApiClient;
import com.mediumapi.domain.search.MediumSearchArticles;
import com.mediumapi.domain.search.MediumSearchLists;
import com.mediumapi.domain.search.MediumSearchPublications;
import com.mediumapi.domain.search.MediumSearchTags;
import com.mediumapi.domain.search.MediumSearchUsers;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface SearchApi {
    default public SearchApiClient getDelegate() {
        return new SearchApiClient(){};
    }

    @Operation(operationId="searchArticlesGet", summary="Search Articles", description="Returns the list of `articles_ids` for the given search query results. (Max Length = 1000) ", tags={"Search"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumSearchArticles.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/search/articles"}, produces={"application/json"})
    default public ResponseEntity<MediumSearchArticles> searchArticlesGet(@NotNull @Parameter(name="query", description="Search query", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="query", required=true) String query) {
        return this.getDelegate().searchArticlesGet(query);
    }

    @Operation(operationId="searchListsGet", summary="Search Lists", description="Returns an array of `list_ids` for the given search query results. (Max Length = 1000) ", tags={"Search"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumSearchLists.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/search/lists"}, produces={"application/json"})
    default public ResponseEntity<MediumSearchLists> searchListsGet(@NotNull @Parameter(name="query", description="Search query", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="query", required=true) String query) {
        return this.getDelegate().searchListsGet(query);
    }

    @Operation(operationId="searchPublicationsGet", summary="Search Publications", description="Returns the list of `publication_ids` for the given search query results. (Max Length = 1000) ", tags={"Search"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumSearchPublications.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/search/publications"}, produces={"application/json"})
    default public ResponseEntity<MediumSearchPublications> searchPublicationsGet(@NotNull @Parameter(name="query", description="Search query", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="query", required=true) String query) {
        return this.getDelegate().searchPublicationsGet(query);
    }

    @Operation(operationId="searchTagsGet", summary="Search Tags", description="Returns a list of `tags` for the given search query results. (Max Length = 1000) ", tags={"Search"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumSearchTags.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/search/tags"}, produces={"application/json"})
    default public ResponseEntity<MediumSearchTags> searchTagsGet(@NotNull @Parameter(name="query", description="Search query", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="query", required=true) String query) {
        return this.getDelegate().searchTagsGet(query);
    }

    @Operation(operationId="searchUsersGet", summary="Search Users", description="Returns a list of `user_ids` for the given search query results. (Max Length = 1000) ", tags={"Search"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumSearchUsers.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/search/users"}, produces={"application/json"})
    default public ResponseEntity<MediumSearchUsers> searchUsersGet(@NotNull @Parameter(name="query", description="Search query", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="query", required=true) String query) {
        return this.getDelegate().searchUsersGet(query);
    }
}

