/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.apiclient;

import com.mediumapi.client.UserApiClient;
import com.mediumapi.domain.users.MediumUser;
import com.mediumapi.domain.users.MediumUserArticles;
import com.mediumapi.domain.users.MediumUserFollowers;
import com.mediumapi.domain.users.MediumUserFollowing;
import com.mediumapi.domain.users.MediumUserInterests;
import com.mediumapi.domain.users.MediumUserLists;
import com.mediumapi.domain.users.MediumUserPublicationFollowing;
import com.mediumapi.domain.users.MediumUserPublications;
import com.mediumapi.domain.users.MediumUserTopArticles;
import com.mediumapi.domain.welcome.UserIdForUsernameGet200Response;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface UserApi {
    default public UserApiClient getDelegate() {
        return new UserApiClient(){};
    }

    @Operation(operationId="userIdForUsernameGet", summary="Get User ID", description="Returns the unique `user_id` for the given `username`.  **Note:** You can find the `username` from the user's/author's profile page URL.  - **username**.medium.com - medium.com/@**username** ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserIdForUsernameGet200Response.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/id_for/{username}"}, produces={"application/json"})
    default public ResponseEntity<UserIdForUsernameGet200Response> userIdForUsernameGet(@Parameter(name="username", description="It's a unique string chosen by every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="username") String username) {
        return this.getDelegate().userIdForUsernameGet(username);
    }

    @Operation(operationId="userUserIdArticlesGet", summary="Get User's Articles", description="Returns the list of articles (`article_ids`) written by the given user. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserArticles.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/articles"}, produces={"application/json"})
    default public ResponseEntity<MediumUserArticles> userUserIdArticlesGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdArticlesGet(userId);
    }

    @Operation(operationId="userUserIdFollowersGet", summary="Get User Followers", description="Returns the list of `user_ids` of the user's followers.  **Note:** When you get the response from the API, it will include an attribute called `next`.  You can use this next attribute as query string parameter (`after`) when you make your next API request.  This way, you can get the followers that come after the one you're currently looking at. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserFollowers.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/followers"}, produces={"application/json"})
    default public ResponseEntity<MediumUserFollowers> userUserIdFollowersGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId, @Parameter(name="count", description="To limit the number of results. (count <= 25)", in=ParameterIn.QUERY) @Valid @RequestParam(value="count", required=false) Integer count, @Parameter(name="after", description="To get the results after a particular follower's user id.", in=ParameterIn.QUERY) @Valid @RequestParam(value="after", required=false) String after) {
        return this.getDelegate().userUserIdFollowersGet(userId, count, after);
    }

    @Operation(operationId="userUserIdFollowingGet", summary="Get User Following", description="Returns a list of users (`user_ids`) that the given user is following.  Use the `count` query parameter (_optional_) to limit the number of results. (count <= 1500)  **Note:** This list does not contain the `publication_ids` of the publications that the user is following. To get those, please use _Get User Publication Following_ endpoint (`/user/{user_id}/publication_following`). ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserFollowing.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/following"}, produces={"application/json"})
    default public ResponseEntity<MediumUserFollowing> userUserIdFollowingGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId, @Parameter(name="count", description="To limit the number of results. (count < 1500)", in=ParameterIn.QUERY) @Valid @RequestParam(value="count", required=false) Integer count) {
        return this.getDelegate().userUserIdFollowingGet(userId, count);
    }

    @Operation(operationId="userUserIdGet", summary="Get User Info", description="Returns user-related information such as their - Username - Full name - Bio - Followers count - Following count - Publication Following count - Twitter Username - Profile Image URL - Background Image URL - Logo Image URL - Tipping Link - List of tags in which the user is Top Writer - When did the user become a Medium Member (conditional) - Whether the user has Lists (boolean) - Whether the user is a Medium-verified book author (boolean) - Whether the user is enrolled in Medium Partner Program (boolean) - Whether the user has allowed notes on their articles (boolean) - Whether the user is suspended or not (boolean)  **Note:** If you don't know the `user_id`, you can get it from the _Get User ID_ endpoint (`/user/id_for/{username}`). ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUser.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}"}, produces={"application/json"})
    default public ResponseEntity<MediumUser> userUserIdGet(@Parameter(name="user_id", description="It's a unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdGet(userId);
    }

    @Operation(operationId="userUserIdInterestsGet", summary="Get User's Interests", description="Returns a list of tags that the given user follows. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserInterests.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/interests"}, produces={"application/json"})
    default public ResponseEntity<MediumUserInterests> userUserIdInterestsGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdInterestsGet(userId);
    }

    @Operation(operationId="userUserIdListsGet", summary="Get User's Lists", description="Returns an array of `list_ids` created by the user.  **Note:** You can check whether the use has created lists or not beforehand. Check the  `has_list` attribute in the \"Article Info\" endpoint. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserLists.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/lists"}, produces={"application/json"})
    default public ResponseEntity<MediumUserLists> userUserIdListsGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdListsGet(userId);
    }

    @Operation(operationId="userUserIdPublicationFollowingGet", summary="Get User Publication Following", description="Returns a list of publications (`publication_ids`) that the given user is following. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserPublicationFollowing.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/publication_following"}, produces={"application/json"})
    default public ResponseEntity<MediumUserPublicationFollowing> userUserIdPublicationFollowingGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdPublicationFollowingGet(userId);
    }

    @Operation(operationId="userUserIdPublicationsGet", summary="Get User's Publications", description="Returns 2 lists of `publication_ids` where the given user is either an admin (creator/editor) or a contributing writer. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserPublications.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/publications"}, produces={"application/json"})
    default public ResponseEntity<MediumUserPublications> userUserIdPublicationsGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdPublicationsGet(userId);
    }

    @Operation(operationId="userUserIdTopArticlesGet", summary="Get User's Top Articles", description="Returns a list of `article_ids` of the top 10 articles on the user's profile, for a given `user_id`. ", tags={"User"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediumUserTopArticles.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/user/{user_id}/top_articles"}, produces={"application/json"})
    default public ResponseEntity<MediumUserTopArticles> userUserIdTopArticlesGet(@Parameter(name="user_id", description="Unique hash id assigned to every single Medium user.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        return this.getDelegate().userUserIdTopArticlesGet(userId);
    }
}

