/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.client;

import com.mediumapi.domain.list.MediumList;
import com.mediumapi.domain.list.MediumListArticles;
import com.mediumapi.domain.list.MediumListResponses;
import com.mediumapi.util.MediumApiUtil;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;

public interface ListApiClient {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    default public ResponseEntity<MediumListArticles> listListIdArticlesGet(String listId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{\"list_articles\": [\"e7240190382c\", \"d595c8c221da\", \"56fe247feb16\", \"5ac9f5f82ffd\", \"dd2cf884546b\", \"8ff906d16c03\", \"2e28ed05036f\", \"44edefd43f09\", \"0e6c2f374410\", \"fcc740792175\"], \"count\": 10, \"id\": \"3d8f744f5370\"}";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumList> listListIdGet(String listId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"last_item_inserted_at\" : \"2023-03-12 06:53:02\", \"thumbnail\" : \"https://miro.medium.com/0*8f634a2860234802375db89fbfcccb5cc717f3fd.jpeg\", \"responses_count\" : 1, \"voters\" : 1, \"author\" : \"1985b61817c3\", \"name\" : \"Medium API\", \"count\" : 18, \"description\" : \"Collections of all the articles and resources related to Medium API\", \"created_at\" : \"2023-03-12 06:46:46\", \"id\" : \"38f9e0f9bea6\", \"claps\" : 48 }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumListResponses> listListIdResponsesGet(String listId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{\"count\": 2, \"responses\": [\"f31a257b42e8\", \"a62b717bca13\"], \"id\": \"3d8f744f5370\"}";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

