/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.client;

import com.mediumapi.domain.publication.MediumPublication;
import com.mediumapi.domain.publication.MediumPublicationArticles;
import com.mediumapi.domain.publication.MediumPublicationID;
import com.mediumapi.domain.publication.MediumPublicationNewsletter;
import com.mediumapi.util.MediumApiUtil;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;

public interface PublicationApiClient {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    default public ResponseEntity<MediumPublicationID> publicationIdForPublicationSlugGet(String publicationSlug) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"publication_id\" : \"29038077e4c6\", \"publication_slug\" : \"codex\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumPublicationArticles> publicationPublicationIdArticlesGet(String publicationId, String from) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{\"publication_articles\": [\"638fb16c5092\", \"8100fa230c7d\", \"dafe61eabe34\", \"b22a38900f39\", \"5c2e28922659\", \"78d8ecab19c4\", \"52f352912025\", \"9bed21ed3432\", \"e4ccce6ab64b\", \"8009cad3c111\", \"bc63d4ada624\", \"af749790e33b\", \"c3fabbd0e00b\", \"d23a4c3ec0cd\", \"b830a1f9c9d5\", \"8c58a7c93ca0\", \"581d31dd625f\", \"b13dd00dc212\", \"763c88143560\", \"73b72c3b977a\", \"993a4acf3d97\", \"cfbff2388d04\", \"f853beb264f6\", \"50b605599b1b\", \"2c7327bf1928\"], \"publication_id\": \"98111c9905da\", \"from\": \"2022-08-13 03:08:16\", \"to\": \"2022-08-05 12:02:25\"}";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumPublication> publicationPublicationIdGet(String publicationId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"creator\" : \"8a819983d566\", \"twitter_username\" : \"towards_AI\", \"description\" : \"Towards AI is the world's leading AI and technology publication. Publishing unbiased AI and technology-related articles. Read by thought-leaders and decision-makers around the world.\", \"url\" : \"pub.towardsai.net\", \"tags\" : [ \"ARTIFICIAL INTELLIGENCE\", \"ARTIFICIAL INTELLIGENCE\" ], \"followers\" : 25260, \"facebook_pagename\" : \"towardsAl\", \"name\" : \"Towards AI\", \"tagline\" : \"The World's Leading AI and Technology Publication\", \"id\" : \"98111c9905da\", \"instagram_username\" : \"towards_ai\", \"slug\" : \"towards-artificial-intelligence\", \"editors\" : [ \"aea8a19ea239\", \"aea8a19ea239\" ] }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumPublicationNewsletter> publicationPublicationIdNewsletterGet(String publicationId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"image\" : \"https://miro.medium.com/1*j2OVd7j2o2FHeE7T8TzpXw.png\", \"subscribers\" : 6752, \"name\" : \"This AI newsletter is all you need\", \"creator_id\" : \"aea8a19ea239\", \"description\" : \"We have moved our newsletter. Subscribe \u2192 https://ws.towardsai.net/subscribe\", \"id\" : \"d710a73cd042\", \"slug\" : \"this-ai-newsletter-is-all-you-need\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

