/*
 * Decompiled with CFR 0.152.
 */
package com.mediumapi.client;

import com.mediumapi.domain.users.MediumUser;
import com.mediumapi.domain.users.MediumUserArticles;
import com.mediumapi.domain.users.MediumUserFollowers;
import com.mediumapi.domain.users.MediumUserFollowing;
import com.mediumapi.domain.users.MediumUserInterests;
import com.mediumapi.domain.users.MediumUserLists;
import com.mediumapi.domain.users.MediumUserPublicationFollowing;
import com.mediumapi.domain.users.MediumUserPublications;
import com.mediumapi.domain.users.MediumUserTopArticles;
import com.mediumapi.domain.welcome.UserIdForUsernameGet200Response;
import com.mediumapi.util.MediumApiUtil;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;

public interface UserApiClient {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    default public ResponseEntity<UserIdForUsernameGet200Response> userIdForUsernameGet(String username) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"id\" : \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserArticles> userUserIdArticlesGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"count\" : 5, \"associated_articles\" : [\"562c5821b5f0\", \"95f4919cc39c\", \"077229e514a3\", \"c9a4be35cb93\", \"05a740c035cc\"], \"id\" : \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserFollowers> userUserIdFollowersGet(String userId, Integer count, String after) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"next\" : \"16759d70a68f\", \"total_followers\" : 721, \"followers\" : [\"14609d40b731\", \"148ae689f366\", \"14daabbff886\", \"150aaf6fae67\", \"1556eaf34b46\", \"157ac0b7fce4\", \"15f72b3c21f1\", \"160c3e933453\", \"162e5e73459a\", \"16759d70a68f\"], \"count\" : 10, \"id\" : \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserFollowing> userUserIdFollowingGet(String userId, Integer count) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"following\" : [\"3340d9dd0981\", \"51e7eb466f57\", \"c0db304eefe1\", \"db7a1a122aa\", \"799bdc99a0fd\", \"3d91a45f0e94\", \"41f99c370629\", \"cfa71f272740\", \"4a142a63b9a0\", \"Infinity\"], \"id\" : \"14d5c41e0264\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUser> userUserIdGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"has_list\" : true, \"bg_image_url\" : \"https://miro.medium.com/1*5EKkWUnrRoveFz88dcWP4Q.png\", \"allow_notes\" : true, \"logo_image_url\" : \"https://miro.medium.com/1*jp6zL2GND2FnDy1WGZOdpQ.png\", \"image_url\" : \"https://miro.medium.com/1*C92Hx7k9nRM7TPlrmhgW9w.jpeg\", \"is_book_author\" : false, \"top_writer_in\" : [ \"programming\", \"programming\" ], \"twitter_username\" : \"one_anachronism\", \"bio\" : \"Obsessed with Tech Biz Arts & Words; Does NOT dumb down the writing; Skilled Wordsmith; Delivers the best\", \"is_suspended\" : false, \"publication_following_count\" : 2, \"medium_member_at\" : \"2020-06-24 16:05:46\", \"following_count\" : 4, \"is_writer_program_enrolled\" : true, \"followers_count\" : 450, \"id\" : \"1985b61817c3\", \"fullname\" : \"Nishu Jain\", \"tipping_link\" : \"https://www.paypal.com/paypalme/sanskarjain1997\", \"username\" : \"nishu-jain\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserInterests> userUserIdInterestsGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"tags_followed\" : [\"software-engineering\", \"startup\", \"machine-learning\", \"data-science\", \"blockchain\"], \"count\" : 5, \"id\" : \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserLists> userUserIdListsGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"lists\" : [\"321cfd9966ec\", \"ba3904884898\", \"b8a117567230\", \"9516ed2145ae\", \"24356f9a9c6e\", \"e8b1c393bcff\", \"95b41261bee0\", \"4ecdbfd97d05\"], \"count\" : 8, \"id\" : \"5142451174a3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserPublicationFollowing> userUserIdPublicationFollowingGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"publication_following\" : [\"aa36b7f642de\", \"b7e45b22fec3\"], \"count\" : 2, \"id\" : \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserPublications> userUserIdPublicationsGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"id\": \"14d5c41e0264\", \"publications\": { \"admin_in\": [\"bff2346ccdf1\", \"df81adaf6236\", \"9830e436a84\", \"aec755e28853\", \"ac4c2146e2f\", \"a7d8d7c02da\", \"ab314b84960a\"], \"writer_in\": [\"6cb21729512d\", \"78d064101951\", \"7adf33e44ae3\", \"3f6ecf56618\", \"193b68bd4fba\", \"d3eff52d6f1c\", \"998e693d29cd\", \"40187e704f1c\", \"48e972f5c24e\", \"65d07f93c269\"] } }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<MediumUserTopArticles> userUserIdTopArticlesGet(String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"top_articles\": [\"562c5821b5f0\", \"95f4919cc39c\", \"077229e514a3\", \"c9a4be35cb93\", \"05a740c035cc\", \"23a287916d3f\", \"9263875a3649\", \"6c34414177bd\", \"9867ba29a923\", \"65a63626c04e\"], \"id\": \"1985b61817c3\" }";
                MediumApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

