/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.SimpleVisitor;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.Schema;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.parser.ConstValueElement;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

final class ConstantBuilder {
    private final TypeResolver typeResolver;
    private final Schema schema;

    public ConstantBuilder(TypeResolver typeResolver, Schema schema) {
        this.typeResolver = typeResolver;
        this.schema = schema;
    }

    void generateFieldInitializer(final CodeBlock.Builder initializer, final NameAllocator allocator, final AtomicInteger scope, final String name, final ThriftType tt, final ConstValueElement value, final boolean needsDeclaration) {
        tt.getTrueType().accept((ThriftType.Visitor)new SimpleVisitor<Void>(){

            @Override
            public Void visitBuiltin(ThriftType builtinType) {
                CodeBlock init = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, tt, value);
                initializer.addStatement("$L = $L", new Object[]{name, init});
                return null;
            }

            public Void visitEnum(ThriftType userType) {
                CodeBlock item = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, tt, value);
                initializer.addStatement("$L = $L", new Object[]{name, item});
                return null;
            }

            public Void visitList(ThriftType.ListType listType) {
                List list = (List)value.value();
                ThriftType elementType = listType.elementType().getTrueType();
                TypeName elementTypeName = ConstantBuilder.this.typeResolver.getJavaClass(elementType);
                ParameterizedTypeName genericName = ParameterizedTypeName.get((ClassName)TypeNames.LIST, (TypeName[])new TypeName[]{elementTypeName});
                ParameterizedTypeName listImplName = ConstantBuilder.this.typeResolver.listOf(elementTypeName);
                this.generateSingleElementCollection(elementType, (TypeName)genericName, (TypeName)listImplName, list);
                return null;
            }

            public Void visitSet(ThriftType.SetType setType) {
                List set = (List)value.value();
                ThriftType elementType = setType.elementType().getTrueType();
                TypeName elementTypeName = ConstantBuilder.this.typeResolver.getJavaClass(elementType);
                ParameterizedTypeName genericName = ParameterizedTypeName.get((ClassName)TypeNames.SET, (TypeName[])new TypeName[]{elementTypeName});
                ParameterizedTypeName setImplName = ConstantBuilder.this.typeResolver.setOf(elementTypeName);
                this.generateSingleElementCollection(elementType, (TypeName)genericName, (TypeName)setImplName, set);
                return null;
            }

            private void generateSingleElementCollection(ThriftType elementType, TypeName genericName, TypeName collectionImplName, List<ConstValueElement> values) {
                if (needsDeclaration) {
                    initializer.addStatement("$T $N = new $T()", new Object[]{genericName, name, collectionImplName});
                } else {
                    initializer.addStatement("$N = new $T()", new Object[]{name, collectionImplName});
                }
                for (ConstValueElement element : values) {
                    CodeBlock elementName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, elementType, element);
                    initializer.addStatement("$N.add($L)", new Object[]{name, elementName});
                }
            }

            public Void visitMap(ThriftType.MapType mapType) {
                Map map = (Map)value.value();
                ThriftType keyType = mapType.keyType().getTrueType();
                ThriftType valueType = mapType.valueType().getTrueType();
                TypeName keyTypeName = ConstantBuilder.this.typeResolver.getJavaClass(keyType);
                TypeName valueTypeName = ConstantBuilder.this.typeResolver.getJavaClass(valueType);
                ParameterizedTypeName mapImplName = ConstantBuilder.this.typeResolver.mapOf(keyTypeName, valueTypeName);
                if (needsDeclaration) {
                    initializer.addStatement("$T $N = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)TypeNames.MAP, (TypeName[])new TypeName[]{keyTypeName, valueTypeName}), name, mapImplName});
                } else {
                    initializer.addStatement("$N = new $T()", new Object[]{name, mapImplName});
                }
                for (Map.Entry entry : map.entrySet()) {
                    CodeBlock keyName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, keyType, (ConstValueElement)entry.getKey());
                    CodeBlock valueName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, valueType, (ConstValueElement)entry.getValue());
                    initializer.addStatement("$N.put($L, $L)", new Object[]{name, keyName, valueName});
                }
                return null;
            }

            public Void visitUserType(ThriftType userType) {
                throw new UnsupportedOperationException("struct-type default values are not yet implemented");
            }

            public Void visitTypedef(ThriftType.TypedefType typedefType) {
                throw new AssertionError((Object)"Should not be possible!");
            }
        });
    }

    CodeBlock renderConstValue(final CodeBlock.Builder block, final NameAllocator allocator, final AtomicInteger scope, ThriftType type, final ConstValueElement value) {
        return (CodeBlock)type.accept((ThriftType.Visitor)new ThriftType.Visitor<CodeBlock>(){

            public CodeBlock visitBool() {
                String name;
                if (value.kind() == ConstValueElement.Kind.IDENTIFIER) {
                    name = "true".equals(value.value()) ? "true" : "false";
                } else if (value.kind() == ConstValueElement.Kind.INTEGER) {
                    name = (Long)value.value() == 0L ? "false" : "true";
                } else {
                    throw new AssertionError((Object)("Invalid boolean constant: " + value.value() + " at " + value.location()));
                }
                return CodeBlock.builder().add(name, new Object[0]).build();
            }

            public CodeBlock visitByte() {
                return CodeBlock.builder().add("(byte) $L", new Object[]{value.getAsInt()}).build();
            }

            public CodeBlock visitI16() {
                return CodeBlock.builder().add("(short) $L", new Object[]{value.getAsInt()}).build();
            }

            public CodeBlock visitI32() {
                return CodeBlock.builder().add("$L", new Object[]{value.getAsInt()}).build();
            }

            public CodeBlock visitI64() {
                return CodeBlock.builder().add("$L", new Object[]{value.getAsLong()}).build();
            }

            public CodeBlock visitDouble() {
                return CodeBlock.builder().add("(double) $L", new Object[]{value.getAsDouble()}).build();
            }

            public CodeBlock visitString() {
                return CodeBlock.builder().add("$S", new Object[]{value.getAsString()}).build();
            }

            public CodeBlock visitBinary() {
                throw new UnsupportedOperationException("Binary literals are not supported");
            }

            public CodeBlock visitVoid() {
                throw new AssertionError((Object)"Void literals are meaningless, what are you even doing");
            }

            public CodeBlock visitEnum(ThriftType tt) {
                EnumType.Member member;
                block7: {
                    EnumType enumType;
                    try {
                        enumType = ConstantBuilder.this.schema.findEnumByType(tt);
                    }
                    catch (NoSuchElementException e) {
                        throw new AssertionError((Object)("Missing enum type: " + tt.name()));
                    }
                    try {
                        if (value.kind() == ConstValueElement.Kind.INTEGER) {
                            member = enumType.findMemberById(value.getAsInt());
                            break block7;
                        }
                        if (value.kind() == ConstValueElement.Kind.IDENTIFIER) {
                            String id = value.getAsString();
                            int ix = id.lastIndexOf(46);
                            if (ix != -1) {
                                id = id.substring(ix + 1);
                            }
                            member = enumType.findMemberByName(id);
                            break block7;
                        }
                        throw new AssertionError((Object)("Constant value kind " + value.kind() + " is not possibly an enum; validation bug"));
                    }
                    catch (NoSuchElementException e) {
                        throw new IllegalStateException("No enum member in " + enumType.name() + " with value " + value.value());
                    }
                }
                return CodeBlock.builder().add("$T.$L", new Object[]{ConstantBuilder.this.typeResolver.getJavaClass(tt), member.name()}).build();
            }

            public CodeBlock visitList(ThriftType.ListType listType) {
                if (value.getAsList().isEmpty()) {
                    return CodeBlock.builder().add("$T.emptyList()", new Object[]{TypeNames.COLLECTIONS}).build();
                }
                return this.visitCollection((ThriftType)listType, "list", "unmodifiableList");
            }

            public CodeBlock visitSet(ThriftType.SetType setType) {
                if (value.getAsList().isEmpty()) {
                    return CodeBlock.builder().add("$T.emptySet()", new Object[]{TypeNames.COLLECTIONS}).build();
                }
                return this.visitCollection((ThriftType)setType, "set", "unmodifiableSet");
            }

            public CodeBlock visitMap(ThriftType.MapType mapType) {
                if (value.getAsMap().isEmpty()) {
                    return CodeBlock.builder().add("$T.emptyMap()", new Object[]{TypeNames.COLLECTIONS}).build();
                }
                return this.visitCollection((ThriftType)mapType, "map", "unmodifiableMap");
            }

            private CodeBlock visitCollection(ThriftType type, String tempName, String method) {
                String name = allocator.newName(tempName, (Object)scope.getAndIncrement());
                ConstantBuilder.this.generateFieldInitializer(block, allocator, scope, name, type, value, true);
                return CodeBlock.builder().add("$T.$L($N)", new Object[]{TypeNames.COLLECTIONS, method, name}).build();
            }

            public CodeBlock visitUserType(ThriftType userType) {
                throw new IllegalStateException("nested structs not implemented");
            }

            public CodeBlock visitTypedef(ThriftType.TypedefType typedefType) {
                return null;
            }
        });
    }
}

