/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.google.common.base.Strings;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ThriftType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

final class TypeResolver {
    private final Map<String, ClassName> nameCache = new LinkedHashMap<String, ClassName>();
    private ClassName listClass = ClassName.get(ArrayList.class);
    private ClassName setClass = ClassName.get(HashSet.class);
    private ClassName mapClass = ClassName.get(HashMap.class);
    private final ThriftType.Visitor<TypeName> typeNameVisitor = new ThriftType.Visitor<TypeName>(){

        public TypeName visitBool() {
            return TypeNames.BOOLEAN;
        }

        public TypeName visitByte() {
            return TypeNames.BYTE;
        }

        public TypeName visitI16() {
            return TypeNames.SHORT;
        }

        public TypeName visitI32() {
            return TypeNames.INTEGER;
        }

        public TypeName visitI64() {
            return TypeNames.LONG;
        }

        public TypeName visitDouble() {
            return TypeNames.DOUBLE;
        }

        public TypeName visitString() {
            return TypeNames.STRING;
        }

        public TypeName visitBinary() {
            return TypeNames.BYTE_STRING;
        }

        public TypeName visitVoid() {
            return TypeNames.VOID;
        }

        public TypeName visitEnum(ThriftType userType) {
            return this.visitUserType(userType);
        }

        public TypeName visitList(ThriftType.ListType listType) {
            ThriftType elementType = listType.elementType().getTrueType();
            TypeName elementTypeName = (TypeName)elementType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.LIST, (TypeName[])new TypeName[]{elementTypeName});
        }

        public TypeName visitSet(ThriftType.SetType setType) {
            ThriftType elementType = setType.elementType().getTrueType();
            TypeName elementTypeName = (TypeName)elementType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.SET, (TypeName[])new TypeName[]{elementTypeName});
        }

        public TypeName visitMap(ThriftType.MapType mapType) {
            ThriftType keyType = mapType.keyType().getTrueType();
            ThriftType valueType = mapType.valueType().getTrueType();
            TypeName keyTypeName = (TypeName)keyType.accept((ThriftType.Visitor)this);
            TypeName valueTypeName = (TypeName)valueType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.MAP, (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        }

        public TypeName visitUserType(ThriftType userType) {
            String packageName = userType.getNamespace(NamespaceScope.JAVA);
            if (Strings.isNullOrEmpty((String)packageName)) {
                throw new AssertionError((Object)"Missing namespace.  Did you forget to add 'namespace java'?");
            }
            String key = packageName + "##" + userType.name();
            ClassName cn = (ClassName)TypeResolver.this.nameCache.get(key);
            if (cn == null) {
                cn = ClassName.get((String)packageName, (String)userType.name(), (String[])new String[0]);
                TypeResolver.this.nameCache.put(key, cn);
            }
            return cn;
        }

        public TypeName visitTypedef(ThriftType.TypedefType typedefType) {
            throw new AssertionError((Object)"Typedefs should have been resolved");
        }
    };
    private static final ThriftType.Visitor<Byte> TYPE_CODE_VISITOR = new ThriftType.Visitor<Byte>(){

        public Byte visitBool() {
            return (byte)2;
        }

        public Byte visitByte() {
            return (byte)3;
        }

        public Byte visitI16() {
            return (byte)6;
        }

        public Byte visitI32() {
            return (byte)8;
        }

        public Byte visitI64() {
            return (byte)10;
        }

        public Byte visitDouble() {
            return (byte)4;
        }

        public Byte visitString() {
            return (byte)11;
        }

        public Byte visitBinary() {
            return (byte)11;
        }

        public Byte visitVoid() {
            return (byte)1;
        }

        public Byte visitEnum(ThriftType userType) {
            return (byte)16;
        }

        public Byte visitList(ThriftType.ListType listType) {
            return (byte)15;
        }

        public Byte visitSet(ThriftType.SetType setType) {
            return (byte)14;
        }

        public Byte visitMap(ThriftType.MapType mapType) {
            return (byte)13;
        }

        public Byte visitUserType(ThriftType userType) {
            return (byte)12;
        }

        public Byte visitTypedef(ThriftType.TypedefType typedefType) {
            throw new AssertionError((Object)"Typedefs should have been resolved");
        }
    };

    TypeResolver() {
    }

    void setListClass(ClassName listClass) {
        this.listClass = listClass;
    }

    void setSetClass(ClassName setClass) {
        this.setClass = setClass;
    }

    void setMapClass(ClassName mapClass) {
        this.mapClass = mapClass;
    }

    byte getTypeCode(ThriftType thriftType) {
        return (Byte)thriftType.getTrueType().accept(TYPE_CODE_VISITOR);
    }

    TypeName getJavaClass(ThriftType thriftType) {
        return (TypeName)thriftType.accept(this.typeNameVisitor);
    }

    ParameterizedTypeName listOf(TypeName elementType) {
        return ParameterizedTypeName.get((ClassName)this.listClass, (TypeName[])new TypeName[]{elementType});
    }

    ParameterizedTypeName setOf(TypeName elementType) {
        return ParameterizedTypeName.get((ClassName)this.setClass, (TypeName[])new TypeName[]{elementType});
    }

    ParameterizedTypeName mapOf(TypeName keyType, TypeName valueType) {
        return ParameterizedTypeName.get((ClassName)this.mapClass, (TypeName[])new TypeName[]{keyType, valueType});
    }
}

