/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.google.common.base.Strings;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.gen.ConstantBuilder;
import com.microsoft.thrifty.gen.GenerateReaderVisitor;
import com.microsoft.thrifty.gen.GenerateWriterVisitor;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.Field;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.Service;
import com.microsoft.thrifty.schema.ServiceMethod;
import com.microsoft.thrifty.schema.ThriftType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Modifier;

final class ServiceBuilder {
    private final TypeResolver typeResolver;
    private final ConstantBuilder constantBuilder;

    ServiceBuilder(TypeResolver typeResolver, ConstantBuilder constantBuilder) {
        this.typeResolver = typeResolver;
        this.constantBuilder = constantBuilder;
    }

    TypeSpec buildServiceInterface(Service service) {
        TypeSpec.Builder serviceSpec = TypeSpec.interfaceBuilder((String)service.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!Strings.isNullOrEmpty((String)service.documentation())) {
            serviceSpec.addJavadoc(service.documentation(), new Object[0]);
        }
        if (service.extendsService() != null) {
            ThriftType superType = service.extendsService().getTrueType();
            TypeName superTypeName = this.typeResolver.getJavaClass(superType);
            serviceSpec.addSuperinterface(superTypeName);
        }
        for (ServiceMethod method : service.methods()) {
            NameAllocator allocator = new NameAllocator();
            int tag = 0;
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            if (method.hasJavadoc()) {
                methodBuilder.addJavadoc(method.documentation(), new Object[0]);
            }
            for (Field field : method.paramTypes()) {
                String name = allocator.newName(field.name(), (Object)(++tag));
                ThriftType paramType = field.type().getTrueType();
                TypeName paramTypeName = this.typeResolver.getJavaClass(paramType);
                methodBuilder.addParameter(paramTypeName, name, new Modifier[0]);
            }
            String callbackName = allocator.newName("callback", (Object)(++tag));
            ThriftType returnType = (ThriftType)method.returnType().or((Object)ThriftType.VOID);
            TypeName returnTypeName = returnType == ThriftType.VOID ? TypeName.VOID.box() : this.typeResolver.getJavaClass(returnType.getTrueType());
            ParameterizedTypeName callbackInterfaceName = ParameterizedTypeName.get((ClassName)TypeNames.SERVICE_CALLBACK, (TypeName[])new TypeName[]{returnTypeName});
            methodBuilder.addParameter((TypeName)callbackInterfaceName, callbackName, new Modifier[0]);
            serviceSpec.addMethod(methodBuilder.build());
        }
        return serviceSpec.build();
    }

    TypeSpec buildService(Service service, TypeSpec serviceInterface) {
        String packageName = service.getNamespaceFor(NamespaceScope.JAVA);
        ClassName interfaceTypeName = ClassName.get((String)packageName, (String)serviceInterface.name, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(service.name() + "Client")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)interfaceTypeName);
        if (service.extendsService() != null) {
            ThriftType type = service.extendsService();
            String typeName = type.name() + "Client";
            String ns = type.getNamespace(NamespaceScope.JAVA);
            ClassName javaClass = ClassName.get((String)ns, (String)typeName, (String[])new String[0]);
            builder.superclass((TypeName)javaClass);
        } else {
            builder.superclass((TypeName)TypeNames.SERVICE_CLIENT_BASE);
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addParameter((TypeName)TypeNames.SERVICE_CLIENT_LISTENER, "listener", new Modifier[0]).addStatement("super(protocol, listener)", new Object[0]).build());
        int i = 0;
        for (MethodSpec methodSpec : serviceInterface.methodSpecs) {
            ServiceMethod serviceMethod = (ServiceMethod)service.methods().get(i++);
            TypeSpec call = this.buildCallSpec(serviceMethod);
            builder.addType(call);
            MethodSpec.Builder meth = MethodSpec.methodBuilder((String)methodSpec.name).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters((Iterable)methodSpec.parameters).addExceptions((Iterable)methodSpec.exceptions);
            CodeBlock.Builder body = CodeBlock.builder().add("$[this.enqueue(new $N(", new Object[]{call});
            boolean first = true;
            for (ParameterSpec parameter : methodSpec.parameters) {
                if (first) {
                    body.add("$N", new Object[]{parameter.name});
                    first = false;
                    continue;
                }
                body.add(", $N", new Object[]{parameter.name});
            }
            body.add("));\n$]", new Object[0]);
            meth.addCode(body.build());
            builder.addMethod(meth.build());
        }
        return builder.build();
    }

    private TypeSpec buildCallSpec(ServiceMethod method) {
        ThriftType returnType;
        String name = method.name();
        if (Character.isLowerCase(name.charAt(0))) {
            name = name.length() > 1 ? Character.toUpperCase(name.charAt(0)) + name.substring(1) : name.toUpperCase(Locale.US);
            name = name + "Call";
        }
        TypeName returnTypeName = (returnType = (ThriftType)method.returnType().or((Object)ThriftType.VOID)).equals((Object)ThriftType.VOID) ? TypeName.VOID.box() : this.typeResolver.getJavaClass(returnType.getTrueType());
        ParameterizedTypeName callbackTypeName = ParameterizedTypeName.get((ClassName)TypeNames.SERVICE_CALLBACK, (TypeName[])new TypeName[]{returnTypeName});
        ParameterizedTypeName superclass = ParameterizedTypeName.get((ClassName)TypeNames.SERVICE_METHOD_CALL, (TypeName[])new TypeName[]{returnTypeName});
        boolean hasReturnType = !returnTypeName.equals((Object)TypeName.VOID.box());
        TypeSpec.Builder callBuilder = TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)superclass);
        for (Field field : method.paramTypes()) {
            TypeName javaType = this.typeResolver.getJavaClass(field.type().getTrueType());
            callBuilder.addField(FieldSpec.builder((TypeName)javaType, (String)field.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        }
        callBuilder.addMethod(this.buildCallCtor(method, (TypeName)callbackTypeName));
        callBuilder.addMethod(this.buildSendMethod(method));
        callBuilder.addMethod(this.buildReceiveMethod(method, hasReturnType));
        return callBuilder.build();
    }

    private MethodSpec buildCallCtor(ServiceMethod method, TypeName callbackTypeName) {
        NameAllocator allocator = new NameAllocator();
        AtomicInteger scope = new AtomicInteger(0);
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addStatement("super($S, $T.$L, callback)", new Object[]{method.name(), TypeNames.TMESSAGE_TYPE, method.oneWay() ? "ONEWAY" : "CALL"});
        for (Field field : method.paramTypes()) {
            TypeName javaType = this.typeResolver.getJavaClass(field.type().getTrueType());
            ctor.addParameter(javaType, field.name(), new Modifier[0]);
            if (field.required() && field.defaultValue() == null) {
                ctor.addStatement("if ($L == null) throw new NullPointerException($S)", new Object[]{field.name(), field.name()});
                ctor.addStatement("this.$1L = $1L", new Object[]{field.name()});
                continue;
            }
            if (field.defaultValue() != null) {
                ctor.beginControlFlow("if ($L != null)", new Object[]{field.name()});
                ctor.addStatement("this.$1L = $1L", new Object[]{field.name(), field.name()});
                ctor.nextControlFlow("else", new Object[0]);
                CodeBlock.Builder init = CodeBlock.builder();
                this.constantBuilder.generateFieldInitializer(init, allocator, scope, "this." + field.name(), field.type().getTrueType(), field.defaultValue(), false);
                ctor.addCode(init.build());
                ctor.endControlFlow();
                continue;
            }
            ctor.addStatement("this.$1L = $1L", new Object[]{field.name()});
        }
        ctor.addParameter(callbackTypeName, "callback", new Modifier[0]);
        return ctor.build();
    }

    private MethodSpec buildSendMethod(ServiceMethod method) {
        MethodSpec.Builder send = MethodSpec.methodBuilder((String)"send").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addException((TypeName)TypeNames.IO_EXCEPTION);
        send.addStatement("protocol.writeStructBegin($S)", new Object[]{"args"});
        for (Field field : method.paramTypes()) {
            boolean optional = !field.required();
            ThriftType tt = field.type().getTrueType();
            byte typeCode = this.typeResolver.getTypeCode(tt);
            if (typeCode == 16) {
                typeCode = 8;
            }
            if (optional) {
                send.beginControlFlow("if (this.$L != null)", new Object[]{field.name()});
            }
            send.addStatement("protocol.writeFieldBegin($S, $L, $T.$L)", new Object[]{field.thriftName(), field.id(), TypeNames.TTYPE, TypeNames.getTypeCodeName(typeCode)});
            tt.accept((ThriftType.Visitor)new GenerateWriterVisitor(this.typeResolver, send, "protocol", "this", field));
            send.addStatement("protocol.writeFieldEnd()", new Object[0]);
            if (!optional) continue;
            send.endControlFlow();
        }
        send.addStatement("protocol.writeFieldStop()", new Object[0]);
        send.addStatement("protocol.writeStructEnd()", new Object[0]);
        return send.build();
    }

    private MethodSpec buildReceiveMethod(ServiceMethod method, boolean hasReturnType) {
        final MethodSpec.Builder recv = MethodSpec.methodBuilder((String)"receive").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addParameter((TypeName)TypeNames.MESSAGE_METADATA, "metadata", new Modifier[0]).addException((TypeName)TypeNames.EXCEPTION);
        if (hasReturnType) {
            TypeName retTypeName = this.typeResolver.getJavaClass(((ThriftType)method.returnType().get()).getTrueType());
            recv.returns(retTypeName);
            recv.addStatement("$T result = null", new Object[]{retTypeName});
        } else {
            recv.returns(TypeName.VOID.box());
        }
        for (final Field field : method.exceptionTypes()) {
            TypeName exceptionTypeName = this.typeResolver.getJavaClass(field.type().getTrueType());
            recv.addStatement("$T $L = null", new Object[]{exceptionTypeName, field.name()});
        }
        recv.addStatement("protocol.readStructBegin()", new Object[0]).beginControlFlow("while (true)", new Object[0]).addStatement("$T field = protocol.readFieldBegin()", new Object[]{TypeNames.FIELD_METADATA}).beginControlFlow("if (field.typeId == $T.STOP)", new Object[]{TypeNames.TTYPE}).addStatement("break", new Object[0]).endControlFlow().beginControlFlow("switch (field.fieldId)", new Object[0]);
        if (hasReturnType) {
            ThriftType type = ((ThriftType)method.returnType().get()).getTrueType();
            recv.beginControlFlow("case 0:", new Object[0]);
            new GenerateReaderVisitor(this.typeResolver, recv, "result", type){

                @Override
                protected void useReadValue(String localName) {
                    recv.addStatement("result = $N", new Object[]{localName});
                }
            }.generate();
            recv.endControlFlow();
            recv.addStatement("break", new Object[0]);
        }
        for (final Field field : method.exceptionTypes()) {
            recv.beginControlFlow("case $L:", new Object[]{field.id()});
            new GenerateReaderVisitor(this.typeResolver, recv, field){

                @Override
                protected void useReadValue(String localName) {
                    recv.addStatement("$N = $N", new Object[]{field.name(), localName});
                }
            }.generate();
            recv.endControlFlow();
            recv.addStatement("break", new Object[0]);
        }
        recv.addStatement("default: $T.skip(protocol, field.typeId); break", new Object[]{TypeNames.PROTO_UTIL});
        recv.endControlFlow();
        recv.addStatement("protocol.readFieldEnd()", new Object[0]);
        recv.endControlFlow();
        recv.addStatement("protocol.readStructEnd()", new Object[0]);
        boolean isInControlFlow = false;
        if (hasReturnType) {
            recv.beginControlFlow("if (result != null)", new Object[0]);
            recv.addStatement("return result", new Object[0]);
            isInControlFlow = true;
        }
        for (Field field : method.exceptionTypes()) {
            if (isInControlFlow) {
                recv.nextControlFlow("else if ($L != null)", new Object[]{field.name()});
            } else {
                recv.beginControlFlow("if ($L != null)", new Object[]{field.name()});
                isInControlFlow = true;
            }
            recv.addStatement("throw $L", new Object[]{field.name()});
        }
        if (isInControlFlow) {
            recv.nextControlFlow("else", new Object[0]);
        }
        if (hasReturnType) {
            recv.addStatement("throw new $T($T.$L, $S)", new Object[]{TypeNames.THRIFT_EXCEPTION, TypeNames.THRIFT_EXCEPTION_KIND, ThriftException.Kind.MISSING_RESULT.name(), "Missing result"});
        } else {
            recv.addStatement("return null", new Object[0]);
        }
        if (isInControlFlow) {
            recv.endControlFlow();
        }
        return recv.build();
    }
}

