/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.SimpleVisitor;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.Constant;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.Schema;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.parser.ConstValueElement;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

final class ConstantBuilder {
    private final TypeResolver typeResolver;
    private final Schema schema;

    ConstantBuilder(TypeResolver typeResolver, Schema schema) {
        this.typeResolver = typeResolver;
        this.schema = schema;
    }

    void generateFieldInitializer(final CodeBlock.Builder initializer, final NameAllocator allocator, final AtomicInteger scope, final String name, final ThriftType tt, final ConstValueElement value, final boolean needsDeclaration) {
        tt.getTrueType().accept((ThriftType.Visitor)new SimpleVisitor<Void>(){

            @Override
            public Void visitBuiltin(ThriftType builtinType) {
                CodeBlock init = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, tt, value);
                initializer.addStatement("$L = $L", new Object[]{name, init});
                return null;
            }

            public Void visitEnum(ThriftType userType) {
                CodeBlock item = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, tt, value);
                initializer.addStatement("$L = $L", new Object[]{name, item});
                return null;
            }

            public Void visitList(ThriftType.ListType listType) {
                List list = (List)value.value();
                ThriftType elementType = listType.elementType().getTrueType();
                TypeName elementTypeName = ConstantBuilder.this.typeResolver.getJavaClass(elementType);
                ParameterizedTypeName genericName = ParameterizedTypeName.get((ClassName)TypeNames.LIST, (TypeName[])new TypeName[]{elementTypeName});
                ParameterizedTypeName listImplName = ConstantBuilder.this.typeResolver.listOf(elementTypeName);
                this.generateSingleElementCollection(elementType, (TypeName)genericName, (TypeName)listImplName, list);
                return null;
            }

            public Void visitSet(ThriftType.SetType setType) {
                List set = (List)value.value();
                ThriftType elementType = setType.elementType().getTrueType();
                TypeName elementTypeName = ConstantBuilder.this.typeResolver.getJavaClass(elementType);
                ParameterizedTypeName genericName = ParameterizedTypeName.get((ClassName)TypeNames.SET, (TypeName[])new TypeName[]{elementTypeName});
                ParameterizedTypeName setImplName = ConstantBuilder.this.typeResolver.setOf(elementTypeName);
                this.generateSingleElementCollection(elementType, (TypeName)genericName, (TypeName)setImplName, set);
                return null;
            }

            private void generateSingleElementCollection(ThriftType elementType, TypeName genericName, TypeName collectionImplName, List<ConstValueElement> values) {
                if (needsDeclaration) {
                    initializer.addStatement("$T $N = new $T()", new Object[]{genericName, name, collectionImplName});
                } else {
                    initializer.addStatement("$N = new $T()", new Object[]{name, collectionImplName});
                }
                for (ConstValueElement element : values) {
                    CodeBlock elementName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, elementType, element);
                    initializer.addStatement("$N.add($L)", new Object[]{name, elementName});
                }
            }

            public Void visitMap(ThriftType.MapType mapType) {
                Map map = (Map)value.value();
                ThriftType keyType = mapType.keyType().getTrueType();
                ThriftType valueType = mapType.valueType().getTrueType();
                TypeName keyTypeName = ConstantBuilder.this.typeResolver.getJavaClass(keyType);
                TypeName valueTypeName = ConstantBuilder.this.typeResolver.getJavaClass(valueType);
                ParameterizedTypeName mapImplName = ConstantBuilder.this.typeResolver.mapOf(keyTypeName, valueTypeName);
                if (needsDeclaration) {
                    initializer.addStatement("$T $N = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)TypeNames.MAP, (TypeName[])new TypeName[]{keyTypeName, valueTypeName}), name, mapImplName});
                } else {
                    initializer.addStatement("$N = new $T()", new Object[]{name, mapImplName});
                }
                for (Map.Entry entry : map.entrySet()) {
                    CodeBlock keyName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, keyType, (ConstValueElement)entry.getKey());
                    CodeBlock valueName = ConstantBuilder.this.renderConstValue(initializer, allocator, scope, valueType, (ConstValueElement)entry.getValue());
                    initializer.addStatement("$N.put($L, $L)", new Object[]{name, keyName, valueName});
                }
                return null;
            }

            public Void visitUserType(ThriftType userType) {
                throw new UnsupportedOperationException("struct-type default values are not yet implemented");
            }

            public Void visitTypedef(ThriftType.TypedefType typedefType) {
                throw new AssertionError((Object)"Should not be possible!");
            }
        });
    }

    CodeBlock renderConstValue(CodeBlock.Builder block, NameAllocator allocator, AtomicInteger scope, ThriftType type, ConstValueElement value) {
        return (CodeBlock)type.accept((ThriftType.Visitor)new ConstRenderingVisitor(block, allocator, scope, type, value));
    }

    private class ConstRenderingVisitor
    implements ThriftType.Visitor<CodeBlock> {
        final CodeBlock.Builder block;
        final NameAllocator allocator;
        final AtomicInteger scope;
        final ThriftType type;
        final ConstValueElement value;

        ConstRenderingVisitor(CodeBlock.Builder block, NameAllocator allocator, AtomicInteger scope, ThriftType type, ConstValueElement value) {
            this.block = block;
            this.allocator = allocator;
            this.scope = scope;
            this.type = type;
            this.value = value;
        }

        public CodeBlock visitBool() {
            String name;
            if (this.value.isIdentifier() && ("true".equals(this.value.getAsString()) || "false".equals(this.value.getAsString()))) {
                name = "true".equals(this.value.value()) ? "true" : "false";
            } else if (this.value.isInt()) {
                name = (Long)this.value.value() == 0L ? "false" : "true";
            } else {
                return this.constantOrError("Invalid boolean constant");
            }
            return CodeBlock.builder().add(name, new Object[0]).build();
        }

        public CodeBlock visitByte() {
            if (this.value.isInt()) {
                return CodeBlock.builder().add("(byte) $L", new Object[]{this.value.getAsInt()}).build();
            }
            return this.constantOrError("Invalid byte constant");
        }

        public CodeBlock visitI16() {
            if (this.value.isInt()) {
                return CodeBlock.builder().add("(short) $L", new Object[]{this.value.getAsInt()}).build();
            }
            return this.constantOrError("Invalid i16 constant");
        }

        public CodeBlock visitI32() {
            if (this.value.isInt()) {
                return CodeBlock.builder().add("$L", new Object[]{this.value.getAsInt()}).build();
            }
            return this.constantOrError("Invalid i32 constant");
        }

        public CodeBlock visitI64() {
            if (this.value.isInt()) {
                return CodeBlock.builder().add("$L", new Object[]{this.value.getAsLong()}).build();
            }
            return this.constantOrError("Invalid i64 constant");
        }

        public CodeBlock visitDouble() {
            if (this.value.isInt() || this.value.isDouble()) {
                return CodeBlock.builder().add("(double) $L", new Object[]{this.value.getAsDouble()}).build();
            }
            return this.constantOrError("Invalid double constant");
        }

        public CodeBlock visitString() {
            if (this.value.isString()) {
                return CodeBlock.builder().add("$S", new Object[]{this.value.getAsString()}).build();
            }
            return this.constantOrError("Invalid string constant");
        }

        public CodeBlock visitBinary() {
            throw new UnsupportedOperationException("Binary literals are not supported");
        }

        public CodeBlock visitVoid() {
            throw new AssertionError((Object)"Void literals are meaningless, what are you even doing");
        }

        public CodeBlock visitEnum(ThriftType tt) {
            EnumType.Member member;
            block7: {
                EnumType enumType;
                try {
                    enumType = ConstantBuilder.this.schema.findEnumByType(tt);
                }
                catch (NoSuchElementException e) {
                    throw new AssertionError((Object)("Missing enum type: " + tt.name()));
                }
                try {
                    if (this.value.kind() == ConstValueElement.Kind.INTEGER) {
                        member = enumType.findMemberById(this.value.getAsInt());
                        break block7;
                    }
                    if (this.value.kind() == ConstValueElement.Kind.IDENTIFIER) {
                        String id = this.value.getAsString();
                        int ix = id.lastIndexOf(46);
                        if (ix != -1) {
                            id = id.substring(ix + 1);
                        }
                        member = enumType.findMemberByName(id);
                        break block7;
                    }
                    throw new AssertionError((Object)("Constant value kind " + this.value.kind() + " is not possibly an enum; validation bug"));
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("No enum member in " + enumType.name() + " with value " + this.value.value());
                }
            }
            return CodeBlock.builder().add("$T.$L", new Object[]{ConstantBuilder.this.typeResolver.getJavaClass(tt), member.name()}).build();
        }

        public CodeBlock visitList(ThriftType.ListType listType) {
            if (this.value.isList()) {
                if (this.value.getAsList().isEmpty()) {
                    TypeName elementType = ConstantBuilder.this.typeResolver.getJavaClass(listType.elementType());
                    return CodeBlock.builder().add("$T.<$T>emptyList()", new Object[]{TypeNames.COLLECTIONS, elementType}).build();
                }
                return this.visitCollection((ThriftType)listType, "list", "unmodifiableList");
            }
            return this.constantOrError("Invalid list constant");
        }

        public CodeBlock visitSet(ThriftType.SetType setType) {
            if (this.value.isList()) {
                if (this.value.getAsList().isEmpty()) {
                    TypeName elementType = ConstantBuilder.this.typeResolver.getJavaClass(setType.elementType());
                    return CodeBlock.builder().add("$T.<$T>emptySet()", new Object[]{TypeNames.COLLECTIONS, elementType}).build();
                }
                return this.visitCollection((ThriftType)setType, "set", "unmodifiableSet");
            }
            return this.constantOrError("Invalid set constant");
        }

        public CodeBlock visitMap(ThriftType.MapType mapType) {
            if (this.value.isMap()) {
                if (this.value.getAsMap().isEmpty()) {
                    TypeName keyType = ConstantBuilder.this.typeResolver.getJavaClass(mapType.keyType());
                    TypeName valueType = ConstantBuilder.this.typeResolver.getJavaClass(mapType.valueType());
                    return CodeBlock.builder().add("$T.<$T, $T>emptyMap()", new Object[]{TypeNames.COLLECTIONS, keyType, valueType}).build();
                }
                return this.visitCollection((ThriftType)mapType, "map", "unmodifiableMap");
            }
            return this.constantOrError("Invalid map constant");
        }

        private CodeBlock visitCollection(ThriftType type, String tempName, String method) {
            String name = this.allocator.newName(tempName, (Object)this.scope.getAndIncrement());
            ConstantBuilder.this.generateFieldInitializer(this.block, this.allocator, this.scope, name, type, this.value, true);
            return CodeBlock.builder().add("$T.$L($N)", new Object[]{TypeNames.COLLECTIONS, method, name}).build();
        }

        public CodeBlock visitUserType(ThriftType userType) {
            throw new IllegalStateException("nested structs not implemented");
        }

        public CodeBlock visitTypedef(ThriftType.TypedefType typedefType) {
            return null;
        }

        private CodeBlock constantOrError(String error) {
            error = error + ": " + this.value.value() + " at " + this.value.location();
            if (!this.value.isIdentifier()) {
                throw new IllegalStateException(error);
            }
            ThriftType expectedType = this.type.getTrueType();
            String name = this.value.getAsString();
            String expectedProgram = null;
            int ix = name.indexOf(46);
            if (ix != -1) {
                expectedProgram = name.substring(0, ix);
                name = name.substring(ix + 1);
            }
            for (Constant constant : ConstantBuilder.this.schema.constants()) {
                ThriftType constantType;
                if (!constant.name().equals(name) || !(constantType = constant.type().getTrueType()).equals((Object)expectedType)) continue;
                String programName = constant.location().getProgramName();
                if (expectedProgram != null && !programName.equals(expectedProgram)) continue;
                String packageName = constant.getNamespaceFor(NamespaceScope.JAVA);
                return CodeBlock.builder().add(packageName + ".Constants." + name, new Object[0]).build();
            }
            throw new IllegalStateException(error);
        }
    }
}

