/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.Field;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ThriftType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayDeque;
import java.util.Deque;

class GenerateReaderVisitor
implements ThriftType.Visitor<Void> {
    private Deque<String> nameStack = new ArrayDeque<String>();
    private TypeResolver resolver;
    private NameAllocator nameAllocator;
    private MethodSpec.Builder read;
    private String fieldName;
    private ThriftType fieldType;
    private int scope;

    GenerateReaderVisitor(TypeResolver resolver, MethodSpec.Builder read, Field field) {
        this(resolver, read, field.name(), field.type().getTrueType());
    }

    GenerateReaderVisitor(TypeResolver resolver, MethodSpec.Builder read, String fieldName, ThriftType fieldType) {
        this.resolver = resolver;
        this.read = read;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    public void generate() {
        byte fieldTypeCode = this.resolver.getTypeCode(this.fieldType);
        if (fieldTypeCode == 16) {
            fieldTypeCode = 8;
        }
        String codeName = TypeNames.getTypeCodeName(fieldTypeCode);
        this.read.beginControlFlow("if (field.typeId == $T.$L)", new Object[]{TypeNames.TTYPE, codeName});
        this.nameStack.push("value");
        this.fieldType.accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        this.useReadValue("value");
        this.read.nextControlFlow("else", new Object[0]);
        this.read.addStatement("$T.skip(protocol, field.typeId)", new Object[]{TypeNames.PROTO_UTIL});
        this.read.endControlFlow();
    }

    protected void useReadValue(String localName) {
        this.read.addStatement("builder.$N($N)", new Object[]{this.fieldName, localName});
    }

    public Void visitBool() {
        this.read.addStatement("$T $N = protocol.readBool()", new Object[]{TypeNames.BOOLEAN.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitByte() {
        this.read.addStatement("$T $N = protocol.readByte()", new Object[]{TypeNames.BYTE.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitI16() {
        this.read.addStatement("$T $N = protocol.readI16()", new Object[]{TypeNames.SHORT.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitI32() {
        this.read.addStatement("$T $N = protocol.readI32()", new Object[]{TypeNames.INTEGER.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitI64() {
        this.read.addStatement("$T $N = protocol.readI64()", new Object[]{TypeNames.LONG.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitDouble() {
        this.read.addStatement("$T $N = protocol.readDouble()", new Object[]{TypeNames.DOUBLE.unbox(), this.nameStack.peek()});
        return null;
    }

    public Void visitString() {
        this.read.addStatement("$T $N = protocol.readString()", new Object[]{TypeNames.STRING, this.nameStack.peek()});
        return null;
    }

    public Void visitBinary() {
        this.read.addStatement("$T $N = protocol.readBinary()", new Object[]{TypeNames.BYTE_STRING, this.nameStack.peek()});
        return null;
    }

    public Void visitVoid() {
        throw new AssertionError((Object)"Cannot read void");
    }

    public Void visitEnum(ThriftType userType) {
        String target = this.nameStack.peek();
        String qualifiedJavaName = this.getFullyQualifiedJavaName(userType);
        this.read.addStatement("$1L $2N = $1L.findByValue(protocol.readI32())", new Object[]{qualifiedJavaName, target});
        return null;
    }

    public Void visitList(ThriftType.ListType listType) {
        this.initNameAllocator();
        TypeName elementType = this.resolver.getJavaClass(listType.elementType().getTrueType());
        ParameterizedTypeName genericListType = ParameterizedTypeName.get((ClassName)TypeNames.LIST, (TypeName[])new TypeName[]{elementType});
        ParameterizedTypeName listImplType = this.resolver.listOf(elementType);
        String listInfo = "listMetadata" + this.scope;
        String idx = "i" + this.scope;
        String item = "item" + this.scope;
        this.read.addStatement("$T $N = protocol.readListBegin()", new Object[]{TypeNames.LIST_META, listInfo});
        this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericListType, this.nameStack.peek(), listImplType, listInfo});
        this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, listInfo});
        ++this.scope;
        this.nameStack.push(item);
        listType.elementType().getTrueType().accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        --this.scope;
        this.read.addStatement("$N.add($N)", new Object[]{this.nameStack.peek(), item});
        this.read.endControlFlow();
        this.read.addStatement("protocol.readListEnd()", new Object[0]);
        return null;
    }

    public Void visitSet(ThriftType.SetType setType) {
        this.initNameAllocator();
        TypeName elementType = this.resolver.getJavaClass(setType.elementType().getTrueType());
        ParameterizedTypeName genericSetType = ParameterizedTypeName.get((ClassName)TypeNames.SET, (TypeName[])new TypeName[]{elementType});
        ParameterizedTypeName setImplType = this.resolver.setOf(elementType);
        String setInfo = "setMetadata" + this.scope;
        String idx = "i" + this.scope;
        String item = "item" + this.scope;
        this.read.addStatement("$T $N = protocol.readSetBegin()", new Object[]{TypeNames.SET_META, setInfo});
        this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericSetType, this.nameStack.peek(), setImplType, setInfo});
        this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, setInfo});
        ++this.scope;
        this.nameStack.push(item);
        setType.elementType().accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        --this.scope;
        this.read.addStatement("$N.add($N)", new Object[]{this.nameStack.peek(), item});
        this.read.endControlFlow();
        this.read.addStatement("protocol.readSetEnd()", new Object[0]);
        return null;
    }

    public Void visitMap(ThriftType.MapType mapType) {
        this.initNameAllocator();
        TypeName keyType = this.resolver.getJavaClass(mapType.keyType().getTrueType());
        TypeName valueType = this.resolver.getJavaClass(mapType.valueType().getTrueType());
        ParameterizedTypeName genericMapType = ParameterizedTypeName.get((ClassName)TypeNames.MAP, (TypeName[])new TypeName[]{keyType, valueType});
        ParameterizedTypeName mapImplType = this.resolver.mapOf(keyType, valueType);
        String mapInfo = "mapMetadata" + this.scope;
        String idx = "i" + this.scope;
        String key = "key" + this.scope;
        String value = "value" + this.scope;
        ++this.scope;
        this.read.addStatement("$T $N = protocol.readMapBegin()", new Object[]{TypeNames.MAP_META, mapInfo});
        this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericMapType, this.nameStack.peek(), mapImplType, mapInfo});
        this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, mapInfo});
        this.nameStack.push(key);
        mapType.keyType().accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        this.nameStack.push(value);
        mapType.valueType().accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        this.read.addStatement("$N.put($N, $N)", new Object[]{this.nameStack.peek(), key, value});
        this.read.endControlFlow();
        this.read.addStatement("protocol.readMapEnd()", new Object[0]);
        --this.scope;
        return null;
    }

    public Void visitUserType(ThriftType userType) {
        String qualifiedJavaName = this.getFullyQualifiedJavaName(userType);
        this.read.addStatement("$1L $2N = $1L.ADAPTER.read(protocol)", new Object[]{qualifiedJavaName, this.nameStack.peek()});
        return null;
    }

    public Void visitTypedef(ThriftType.TypedefType typedefType) {
        typedefType.getTrueType().accept((ThriftType.Visitor)this);
        return null;
    }

    private String getFullyQualifiedJavaName(ThriftType type) {
        if (type.isBuiltin() || type.isList() || type.isMap() || type.isSet() || type.isTypedef()) {
            throw new AssertionError((Object)"Only user and enum types are supported");
        }
        String packageName = type.getNamespace(NamespaceScope.JAVA);
        return packageName + "." + type.name();
    }

    private void initNameAllocator() {
        if (this.nameAllocator == null) {
            this.nameAllocator = new NameAllocator();
            this.nameAllocator.newName("protocol", (Object)"protocol");
            this.nameAllocator.newName("builder", (Object)"builder");
            this.nameAllocator.newName("value", (Object)"value");
        }
    }
}

