/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;

class GenerateWriterVisitor
implements ThriftType.Visitor<Void> {
    private TypeResolver resolver;
    private MethodSpec.Builder write;
    private String proto;
    private Deque<String> nameStack = new LinkedList<String>();
    private int scopeLevel;
    private NameAllocator nameAllocator;

    GenerateWriterVisitor(TypeResolver resolver, MethodSpec.Builder write, String proto, String subject, String fieldName) {
        this.resolver = resolver;
        this.write = write;
        this.proto = proto;
        this.nameStack.push(subject + "." + fieldName);
    }

    public Void visitBool(BuiltinType boolType) {
        this.write.addStatement("$N.writeBool($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitByte(BuiltinType byteType) {
        this.write.addStatement("$N.writeByte($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitI16(BuiltinType i16Type) {
        this.write.addStatement("$N.writeI16($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitI32(BuiltinType i32Type) {
        this.write.addStatement("$N.writeI32($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitI64(BuiltinType i64Type) {
        this.write.addStatement("$N.writeI64($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitDouble(BuiltinType doubleType) {
        this.write.addStatement("$N.writeDouble($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitString(BuiltinType stringType) {
        this.write.addStatement("$N.writeString($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitBinary(BuiltinType binaryType) {
        this.write.addStatement("$N.writeBinary($L)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitVoid(BuiltinType voidType) {
        throw new AssertionError((Object)"Fields cannot be void");
    }

    public Void visitEnum(EnumType enumType) {
        this.write.addStatement("$N.writeI32($L.value)", new Object[]{this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitList(ListType listType) {
        this.visitSingleElementCollection(listType.elementType().getTrueType(), "writeListBegin", "writeListEnd");
        return null;
    }

    public Void visitSet(SetType setType) {
        this.visitSingleElementCollection(setType.elementType().getTrueType(), "writeSetBegin", "writeSetEnd");
        return null;
    }

    private void visitSingleElementCollection(ThriftType elementType, String beginMethod, String endMethod) {
        this.initCollectionHelpers();
        String tag = "item" + this.scopeLevel;
        String item = this.nameAllocator.newName(tag, (Object)tag);
        TypeName javaClass = this.resolver.getJavaClass(elementType);
        byte typeCode = this.resolver.getTypeCode(elementType);
        if (typeCode == 16) {
            typeCode = 8;
        }
        String typeCodeName = TypeNames.getTypeCodeName(typeCode);
        this.write.addStatement("$N.$L($T.$L, $L.size())", new Object[]{this.proto, beginMethod, TypeNames.TTYPE, typeCodeName, this.nameStack.peek()});
        this.write.beginControlFlow("for ($T $N : $L)", new Object[]{javaClass, item, this.nameStack.peek()});
        ++this.scopeLevel;
        this.nameStack.push(item);
        elementType.accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        --this.scopeLevel;
        this.write.endControlFlow();
        this.write.addStatement("$N.$L()", new Object[]{this.proto, endMethod});
    }

    public Void visitMap(MapType mapType) {
        this.initCollectionHelpers();
        String entryTag = "entry" + this.scopeLevel;
        String keyTag = "key" + this.scopeLevel;
        String valueTag = "value" + this.scopeLevel;
        String entryName = this.nameAllocator.newName(entryTag, (Object)entryTag);
        String keyName = this.nameAllocator.newName(keyTag, (Object)keyTag);
        String valueName = this.nameAllocator.newName(valueTag, (Object)valueTag);
        ThriftType kt = mapType.keyType().getTrueType();
        ThriftType vt = mapType.valueType().getTrueType();
        byte keyTypeCode = this.resolver.getTypeCode(kt);
        byte valTypeCode = this.resolver.getTypeCode(vt);
        if (keyTypeCode == 16) {
            keyTypeCode = 8;
        }
        if (valTypeCode == 16) {
            valTypeCode = 8;
        }
        this.write.addStatement("$1N.writeMapBegin($2T.$3L, $2T.$4L, $5L.size())", new Object[]{this.proto, TypeNames.TTYPE, TypeNames.getTypeCodeName(keyTypeCode), TypeNames.getTypeCodeName(valTypeCode), this.nameStack.peek()});
        TypeName keyTypeName = this.resolver.getJavaClass(kt);
        TypeName valueTypeName = this.resolver.getJavaClass(vt);
        ParameterizedTypeName entry = ParameterizedTypeName.get((ClassName)TypeNames.MAP_ENTRY, (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        this.write.beginControlFlow("for ($T $N : $L.entrySet())", new Object[]{entry, entryTag, this.nameStack.peek()});
        this.write.addStatement("$T $N = $N.getKey()", new Object[]{keyTypeName, keyName, entryName});
        this.write.addStatement("$T $N = $N.getValue()", new Object[]{valueTypeName, valueName, entryName});
        ++this.scopeLevel;
        this.nameStack.push(keyName);
        kt.accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        this.nameStack.push(valueName);
        vt.accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        --this.scopeLevel;
        this.write.endControlFlow();
        this.write.addStatement("$N.writeMapEnd()", new Object[]{this.proto});
        return null;
    }

    public Void visitStruct(StructType structType) {
        String javaName = structType.getNamespaceFor(NamespaceScope.JAVA) + "." + structType.name();
        this.write.addStatement("$L.ADAPTER.write($N, $L)", new Object[]{javaName, this.proto, this.nameStack.peek()});
        return null;
    }

    public Void visitTypedef(TypedefType typedefType) {
        typedefType.getTrueType().accept((ThriftType.Visitor)this);
        return null;
    }

    public Void visitService(ServiceType serviceType) {
        throw new AssertionError((Object)"Cannot write a service");
    }

    private void initCollectionHelpers() {
        if (this.nameAllocator == null) {
            this.nameAllocator = new NameAllocator();
            this.nameAllocator.newName(this.proto, (Object)this.proto);
        }
    }
}

