/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.google.common.base.Strings;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.microsoft.thrifty.schema.UserType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

final class TypeResolver {
    private final Map<String, ClassName> nameCache = new LinkedHashMap<String, ClassName>();
    private ClassName listClass = ClassName.get(ArrayList.class);
    private ClassName setClass = ClassName.get(HashSet.class);
    private ClassName mapClass = ClassName.get(HashMap.class);
    private final ThriftType.Visitor<TypeName> typeNameVisitor = new ThriftType.Visitor<TypeName>(){

        public TypeName visitVoid(BuiltinType voidType) {
            return TypeNames.VOID;
        }

        public TypeName visitBool(BuiltinType boolType) {
            return TypeNames.BOOLEAN;
        }

        public TypeName visitByte(BuiltinType byteType) {
            return TypeNames.BYTE;
        }

        public TypeName visitI16(BuiltinType i16Type) {
            return TypeNames.SHORT;
        }

        public TypeName visitI32(BuiltinType i32Type) {
            return TypeNames.INTEGER;
        }

        public TypeName visitI64(BuiltinType i64Type) {
            return TypeNames.LONG;
        }

        public TypeName visitDouble(BuiltinType doubleType) {
            return TypeNames.DOUBLE;
        }

        public TypeName visitString(BuiltinType stringType) {
            return TypeNames.STRING;
        }

        public TypeName visitBinary(BuiltinType binaryType) {
            return TypeNames.BYTE_STRING;
        }

        public TypeName visitEnum(EnumType enumType) {
            return this.visitUserType((UserType)enumType);
        }

        public TypeName visitList(ListType listType) {
            ThriftType elementType = listType.elementType().getTrueType();
            TypeName elementTypeName = (TypeName)elementType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.LIST, (TypeName[])new TypeName[]{elementTypeName});
        }

        public TypeName visitSet(SetType setType) {
            ThriftType elementType = setType.elementType().getTrueType();
            TypeName elementTypeName = (TypeName)elementType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.SET, (TypeName[])new TypeName[]{elementTypeName});
        }

        public TypeName visitMap(MapType mapType) {
            ThriftType keyType = mapType.keyType().getTrueType();
            ThriftType valueType = mapType.valueType().getTrueType();
            TypeName keyTypeName = (TypeName)keyType.accept((ThriftType.Visitor)this);
            TypeName valueTypeName = (TypeName)valueType.accept((ThriftType.Visitor)this);
            return ParameterizedTypeName.get((ClassName)TypeNames.MAP, (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        }

        public TypeName visitStruct(StructType structType) {
            return this.visitUserType((UserType)structType);
        }

        public TypeName visitTypedef(TypedefType typedefType) {
            return (TypeName)typedefType.oldType().accept((ThriftType.Visitor)this);
        }

        public TypeName visitService(ServiceType serviceType) {
            return this.visitUserType((UserType)serviceType);
        }

        private TypeName visitUserType(UserType userType) {
            String packageName = userType.getNamespaceFor(NamespaceScope.JAVA);
            if (Strings.isNullOrEmpty((String)packageName)) {
                throw new AssertionError((Object)"Missing namespace.  Did you forget to add 'namespace java'?");
            }
            String key = packageName + "##" + userType.name();
            return (TypeName)TypeResolver.this.nameCache.computeIfAbsent(key, k -> ClassName.get((String)packageName, (String)userType.name(), (String[])new String[0]));
        }
    };
    private static final ThriftType.Visitor<Byte> TYPE_CODE_VISITOR = new ThriftType.Visitor<Byte>(){

        public Byte visitBool(BuiltinType boolType) {
            return (byte)2;
        }

        public Byte visitByte(BuiltinType byteType) {
            return (byte)3;
        }

        public Byte visitI16(BuiltinType i16Type) {
            return (byte)6;
        }

        public Byte visitI32(BuiltinType i32Type) {
            return (byte)8;
        }

        public Byte visitI64(BuiltinType i64Type) {
            return (byte)10;
        }

        public Byte visitDouble(BuiltinType doubleType) {
            return (byte)4;
        }

        public Byte visitString(BuiltinType stringType) {
            return (byte)11;
        }

        public Byte visitBinary(BuiltinType binaryType) {
            return (byte)11;
        }

        public Byte visitVoid(BuiltinType voidType) {
            return (byte)1;
        }

        public Byte visitEnum(EnumType userType) {
            return (byte)16;
        }

        public Byte visitList(ListType listType) {
            return (byte)15;
        }

        public Byte visitSet(SetType setType) {
            return (byte)14;
        }

        public Byte visitMap(MapType mapType) {
            return (byte)13;
        }

        public Byte visitStruct(StructType userType) {
            return (byte)12;
        }

        public Byte visitTypedef(TypedefType typedefType) {
            return (Byte)typedefType.oldType().accept((ThriftType.Visitor)this);
        }

        public Byte visitService(ServiceType serviceType) {
            throw new AssertionError((Object)"Services do not have typecodes");
        }
    };

    TypeResolver() {
    }

    void setListClass(ClassName listClass) {
        this.listClass = listClass;
    }

    void setSetClass(ClassName setClass) {
        this.setClass = setClass;
    }

    void setMapClass(ClassName mapClass) {
        this.mapClass = mapClass;
    }

    byte getTypeCode(ThriftType thriftType) {
        return (Byte)thriftType.getTrueType().accept(TYPE_CODE_VISITOR);
    }

    TypeName getJavaClass(ThriftType thriftType) {
        return (TypeName)thriftType.accept(this.typeNameVisitor);
    }

    ParameterizedTypeName listOf(TypeName elementType) {
        return ParameterizedTypeName.get((ClassName)this.listClass, (TypeName[])new TypeName[]{elementType});
    }

    ParameterizedTypeName setOf(TypeName elementType) {
        return ParameterizedTypeName.get((ClassName)this.setClass, (TypeName[])new TypeName[]{elementType});
    }

    ParameterizedTypeName mapOf(TypeName keyType, TypeName valueType) {
        return ParameterizedTypeName.get((ClassName)this.mapClass, (TypeName[])new TypeName[]{keyType, valueType});
    }
}

