/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.microsoft.thrifty.Obfuscated;
import com.microsoft.thrifty.Redacted;
import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.ThriftField;
import com.microsoft.thrifty.compiler.spi.TypeProcessor;
import com.microsoft.thrifty.gen.ConstantBuilder;
import com.microsoft.thrifty.gen.FieldNamer;
import com.microsoft.thrifty.gen.GenerateReaderVisitor;
import com.microsoft.thrifty.gen.GenerateWriterVisitor;
import com.microsoft.thrifty.gen.ServiceBuilder;
import com.microsoft.thrifty.gen.SimpleVisitor;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.Constant;
import com.microsoft.thrifty.schema.EnumMember;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.Field;
import com.microsoft.thrifty.schema.FieldNamingPolicy;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.Location;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.Schema;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.microsoft.thrifty.schema.UserType;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class ThriftyCodeGenerator {
    private static final String FILE_COMMENT = "Automatically generated by the Thrifty compiler; do not edit!\nGenerated on: ";
    public static final String ADAPTER_FIELDNAME = "ADAPTER";
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private final TypeResolver typeResolver = new TypeResolver();
    private final Schema schema;
    private final FieldNamer fieldNamer;
    private final ConstantBuilder constantBuilder;
    private final ServiceBuilder serviceBuilder;
    private TypeProcessor typeProcessor;
    private boolean emitAndroidAnnotations;
    private boolean emitParcelable;
    private boolean emitFileComment = true;

    public ThriftyCodeGenerator(Schema schema) {
        this(schema, FieldNamingPolicy.DEFAULT);
    }

    public ThriftyCodeGenerator(Schema schema, FieldNamingPolicy namingPolicy) {
        this(schema, namingPolicy, ClassName.get(ArrayList.class), ClassName.get(HashSet.class), ClassName.get(HashMap.class));
    }

    private ThriftyCodeGenerator(Schema schema, FieldNamingPolicy namingPolicy, ClassName listClassName, ClassName setClassName, ClassName mapClassName) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        Preconditions.checkNotNull((Object)namingPolicy, (Object)"namingPolicy");
        Preconditions.checkNotNull((Object)listClassName, (Object)"listClassName");
        Preconditions.checkNotNull((Object)setClassName, (Object)"setClassName");
        Preconditions.checkNotNull((Object)mapClassName, (Object)"mapClassName");
        this.schema = schema;
        this.fieldNamer = new FieldNamer(namingPolicy);
        this.typeResolver.setListClass(listClassName);
        this.typeResolver.setSetClass(setClassName);
        this.typeResolver.setMapClass(mapClassName);
        this.constantBuilder = new ConstantBuilder(this.typeResolver, schema);
        this.serviceBuilder = new ServiceBuilder(this.typeResolver, this.constantBuilder, this.fieldNamer);
    }

    public ThriftyCodeGenerator withListType(String listClassName) {
        this.typeResolver.setListClass(ClassName.bestGuess((String)listClassName));
        return this;
    }

    public ThriftyCodeGenerator withSetType(String setClassName) {
        this.typeResolver.setSetClass(ClassName.bestGuess((String)setClassName));
        return this;
    }

    public ThriftyCodeGenerator withMapType(String mapClassName) {
        this.typeResolver.setMapClass(ClassName.bestGuess((String)mapClassName));
        return this;
    }

    public ThriftyCodeGenerator emitAndroidAnnotations(boolean shouldEmit) {
        this.emitAndroidAnnotations = shouldEmit;
        return this;
    }

    public ThriftyCodeGenerator emitParcelable(boolean emitParcelable) {
        this.emitParcelable = emitParcelable;
        return this;
    }

    public ThriftyCodeGenerator emitFileComment(boolean emitFileComment) {
        this.emitFileComment = emitFileComment;
        return this;
    }

    public ThriftyCodeGenerator usingTypeProcessor(TypeProcessor typeProcessor) {
        this.typeProcessor = typeProcessor;
        return this;
    }

    public void generate(Path directory) throws IOException {
        this.generate((JavaFile file) -> {
            if (file != null) {
                file.writeTo(directory);
            }
        });
    }

    public void generate(File directory) throws IOException {
        this.generate((JavaFile file) -> {
            if (file != null) {
                file.writeTo(directory);
            }
        });
    }

    public void generate(Appendable appendable) throws IOException {
        this.generate((JavaFile file) -> {
            if (file != null) {
                file.writeTo(appendable);
            }
        });
    }

    public ImmutableList<JavaFile> generateTypes() {
        JavaFile file;
        ImmutableList.Builder generatedTypes = ImmutableList.builder();
        for (EnumType type : this.schema.enums()) {
            TypeSpec typeSpec;
            file = this.assembleJavaFile((UserType)type, typeSpec = this.buildEnum(type));
            if (file == null) continue;
            generatedTypes.add((Object)file);
        }
        for (EnumType type : this.schema.structs()) {
            TypeSpec typeSpec;
            file = this.assembleJavaFile((UserType)type, typeSpec = this.buildStruct((StructType)type));
            if (file == null) continue;
            generatedTypes.add((Object)file);
        }
        for (EnumType type : this.schema.exceptions()) {
            TypeSpec typeSpec;
            file = this.assembleJavaFile((UserType)type, typeSpec = this.buildStruct((StructType)type));
            if (file == null) continue;
            generatedTypes.add((Object)file);
        }
        for (EnumType type : this.schema.unions()) {
            TypeSpec typeSpec;
            file = this.assembleJavaFile((UserType)type, typeSpec = this.buildStruct((StructType)type));
            if (file == null) continue;
            generatedTypes.add((Object)file);
        }
        HashMultimap constantsByPackage = HashMultimap.create();
        for (Constant constant : this.schema.constants()) {
            constantsByPackage.put((Object)constant.getNamespaceFor(NamespaceScope.JAVA), (Object)constant);
        }
        for (Map.Entry entry : constantsByPackage.asMap().entrySet()) {
            Collection values;
            TypeSpec spec2;
            String packageName = (String)entry.getKey();
            JavaFile file2 = this.assembleJavaFile(packageName, spec2 = this.buildConst(values = (Collection)entry.getValue()));
            if (file2 == null) continue;
            generatedTypes.add((Object)file2);
        }
        for (ServiceType serviceType : this.schema.services()) {
            TypeSpec spec3;
            JavaFile file3 = this.assembleJavaFile((UserType)serviceType, spec3 = this.serviceBuilder.buildServiceInterface(serviceType));
            if (file3 == null) continue;
            generatedTypes.add((Object)file3);
            file3 = this.assembleJavaFile((UserType)serviceType, spec3 = this.serviceBuilder.buildService(serviceType, spec3));
            if (file3 == null) continue;
            generatedTypes.add((Object)file3);
        }
        return generatedTypes.build();
    }

    private void generate(FileWriter writer) throws IOException {
        for (JavaFile file : this.generateTypes()) {
            writer.write(file);
        }
    }

    @Nullable
    private JavaFile assembleJavaFile(UserType named, TypeSpec spec) {
        String packageName = named.getNamespaceFor(NamespaceScope.JAVA);
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new IllegalArgumentException("A Java package name must be given for java code generation");
        }
        return this.assembleJavaFile(packageName, spec, named.location());
    }

    @Nullable
    private JavaFile assembleJavaFile(String packageName, TypeSpec spec) {
        return this.assembleJavaFile(packageName, spec, null);
    }

    @Nullable
    private JavaFile assembleJavaFile(String packageName, TypeSpec spec, Location location) {
        if (this.typeProcessor != null && (spec = this.typeProcessor.process(spec)) == null) {
            return null;
        }
        JavaFile.Builder file = JavaFile.builder((String)packageName, (TypeSpec)spec).skipJavaLangImports(true);
        if (this.emitFileComment) {
            file.addFileComment(FILE_COMMENT + DATE_FORMATTER.print(System.currentTimeMillis()), new Object[0]);
            if (location != null) {
                file.addFileComment("\nSource: $L", new Object[]{location});
            }
        }
        return file.build();
    }

    @VisibleForTesting
    TypeSpec buildStruct(StructType type) {
        String packageName = type.getNamespaceFor(NamespaceScope.JAVA);
        ClassName structTypeName = ClassName.get((String)packageName, (String)type.name(), (String[])new String[0]);
        ClassName builderTypeName = structTypeName.nestedClass("Builder");
        TypeSpec.Builder structBuilder = TypeSpec.classBuilder((String)type.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(Struct.class);
        if (type.hasJavadoc()) {
            structBuilder.addJavadoc("$L", new Object[]{type.documentation()});
        }
        if (type.isException()) {
            structBuilder.superclass(Exception.class);
        }
        if (type.isDeprecated()) {
            structBuilder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        TypeSpec builderSpec = this.builderFor(type, structTypeName, builderTypeName);
        TypeSpec adapterSpec = this.adapterFor(type, structTypeName, builderTypeName);
        if (this.emitParcelable) {
            this.generateParcelable(type, structTypeName, structBuilder);
        }
        structBuilder.addType(builderSpec);
        structBuilder.addType(adapterSpec);
        structBuilder.addField(FieldSpec.builder((TypeName)((TypeName)adapterSpec.superinterfaces.get(0)), (String)ADAPTER_FIELDNAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $N()", new Object[]{adapterSpec}).build());
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)builderTypeName, "builder", new Modifier[0]);
        for (Field field : type.fields()) {
            String name = this.fieldNamer.getName(field);
            ThriftType fieldType = field.type();
            ThriftType trueType = fieldType.getTrueType();
            TypeName fieldTypeName = this.typeResolver.getJavaClass(trueType);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldTypeName, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(ThriftyCodeGenerator.fieldAnnotation(field));
            if (this.emitAndroidAnnotations) {
                ClassName anno = field.required() ? TypeNames.NOT_NULL : TypeNames.NULLABLE;
                fieldBuilder.addAnnotation(anno);
            }
            if (field.hasJavadoc()) {
                fieldBuilder = fieldBuilder.addJavadoc("$L", new Object[]{field.documentation()});
            }
            if (field.isRedacted()) {
                fieldBuilder = fieldBuilder.addAnnotation(AnnotationSpec.builder(Redacted.class).build());
            }
            if (field.isObfuscated()) {
                fieldBuilder = fieldBuilder.addAnnotation(AnnotationSpec.builder(Obfuscated.class).build());
            }
            if (field.isDeprecated()) {
                fieldBuilder = fieldBuilder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
            }
            structBuilder.addField(fieldBuilder.build());
            CodeBlock.Builder assignment = CodeBlock.builder().add("$[this.$N = ", new Object[]{name});
            if (trueType.isList()) {
                if (!field.required()) {
                    assignment.add("builder.$N == null ? null : ", new Object[]{name});
                }
                assignment.add("$T.unmodifiableList(builder.$N)", new Object[]{TypeNames.COLLECTIONS, name});
            } else if (trueType.isSet()) {
                if (!field.required()) {
                    assignment.add("builder.$N == null ? null : ", new Object[]{name});
                }
                assignment.add("$T.unmodifiableSet(builder.$N)", new Object[]{TypeNames.COLLECTIONS, name});
            } else if (trueType.isMap()) {
                if (!field.required()) {
                    assignment.add("builder.$N == null ? null : ", new Object[]{name});
                }
                assignment.add("$T.unmodifiableMap(builder.$N)", new Object[]{TypeNames.COLLECTIONS, name});
            } else {
                assignment.add("builder.$N", new Object[]{name});
            }
            ctor.addCode(assignment.add(";\n$]", new Object[0]).build());
        }
        structBuilder.addMethod(ctor.build());
        structBuilder.addMethod(this.buildEqualsFor(type));
        structBuilder.addMethod(this.buildHashCodeFor(type));
        structBuilder.addMethod(this.buildToStringFor(type));
        structBuilder.addMethod(this.buildWrite());
        return structBuilder.build();
    }

    private void generateParcelable(StructType structType, ClassName structName, TypeSpec.Builder structBuilder) {
        structBuilder.addSuperinterface((TypeName)TypeNames.PARCELABLE);
        structBuilder.addField(FieldSpec.builder(ClassLoader.class, (String)"CLASS_LOADER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.class.getClassLoader()", new Object[]{structName}).build());
        ParameterizedTypeName creatorType = ParameterizedTypeName.get((ClassName)TypeNames.PARCELABLE_CREATOR, (TypeName[])new TypeName[]{structName});
        TypeSpec creator = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)creatorType).addMethod(MethodSpec.methodBuilder((String)"createFromParcel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)structName).addParameter((TypeName)TypeNames.PARCEL, "source", new Modifier[0]).addStatement("return new $T(source)", new Object[]{structName}).build()).addMethod(MethodSpec.methodBuilder((String)"newArray").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of((TypeName)structName)).addParameter(Integer.TYPE, "size", new Modifier[0]).addStatement("return new $T[size]", new Object[]{structName}).build()).build();
        MethodSpec.Builder parcelCtor = MethodSpec.constructorBuilder().addParameter((TypeName)TypeNames.PARCEL, "in", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        MethodSpec.Builder parcelWriter = MethodSpec.methodBuilder((String)"writeToParcel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.PARCEL, "dest", new Modifier[0]).addParameter(Integer.TYPE, "flags", new Modifier[0]);
        for (Field field : structType.fields()) {
            String name = this.fieldNamer.getName(field);
            TypeName fieldType = this.typeResolver.getJavaClass(field.type().getTrueType());
            parcelCtor.addStatement("this.$N = ($T) in.readValue(CLASS_LOADER)", new Object[]{name, fieldType});
            parcelWriter.addStatement("dest.writeValue(this.$N)", new Object[]{name});
        }
        FieldSpec creatorField = FieldSpec.builder((TypeName)creatorType, (String)"CREATOR", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{creator}).build();
        structBuilder.addField(creatorField).addMethod(MethodSpec.methodBuilder((String)"describeContents").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return 0", new Object[0]).build()).addMethod(parcelCtor.build()).addMethod(parcelWriter.build());
    }

    private TypeSpec builderFor(StructType structType, ClassName structClassName, ClassName builderClassName) {
        ParameterizedTypeName builderSuperclassName = ParameterizedTypeName.get((ClassName)TypeNames.BUILDER, (TypeName[])new TypeName[]{structClassName});
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addSuperinterface((TypeName)builderSuperclassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).returns((TypeName)structClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder resetBuilder = MethodSpec.methodBuilder((String)"reset").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder copyCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)structClassName, "struct", new Modifier[0]);
        MethodSpec.Builder defaultCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (structType.isUnion()) {
            buildMethodBuilder.addStatement("int setFields = 0", new Object[0]);
        }
        NameAllocator allocator = new NameAllocator();
        for (Field field : structType.fields()) {
            String name = this.fieldNamer.getName(field);
            allocator.newName(name, (Object)name);
        }
        AtomicInteger tempNameId = new AtomicInteger(0);
        for (Field field : structType.fields()) {
            ThriftType fieldType = field.type().getTrueType();
            TypeName javaTypeName = this.typeResolver.getJavaClass(fieldType);
            String fieldName = this.fieldNamer.getName(field);
            FieldSpec.Builder f = FieldSpec.builder((TypeName)javaTypeName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (field.hasJavadoc()) {
                f.addJavadoc("$L", new Object[]{field.documentation()});
            }
            if (field.defaultValue() != null) {
                CodeBlock.Builder initializer = CodeBlock.builder();
                this.constantBuilder.generateFieldInitializer(initializer, allocator, tempNameId, "this." + fieldName, fieldType.getTrueType(), field.defaultValue(), false);
                defaultCtor.addCode(initializer.build());
                resetBuilder.addCode(initializer.build());
            } else {
                resetBuilder.addStatement("this.$N = null", new Object[]{fieldName});
            }
            builder.addField(f.build());
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderClassName).addParameter(javaTypeName, fieldName, new Modifier[0]);
            if (field.required()) {
                setterBuilder.beginControlFlow("if ($N == null)", new Object[]{fieldName});
                setterBuilder.addStatement("throw new $T(\"Required field '$L' cannot be null\")", new Object[]{NullPointerException.class, fieldName});
                setterBuilder.endControlFlow();
            }
            setterBuilder.addStatement("this.$N = $N", new Object[]{fieldName, fieldName}).addStatement("return this", new Object[0]);
            builder.addMethod(setterBuilder.build());
            if (structType.isUnion()) {
                buildMethodBuilder.addStatement("if (this.$N != null) ++setFields", new Object[]{fieldName});
            } else if (field.required()) {
                buildMethodBuilder.beginControlFlow("if (this.$N == null)", new Object[]{fieldName});
                buildMethodBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(IllegalStateException.class), "Required field '" + fieldName + "' is missing"});
                buildMethodBuilder.endControlFlow();
            }
            copyCtor.addStatement("this.$N = $N.$N", new Object[]{fieldName, "struct", fieldName});
        }
        if (structType.isUnion()) {
            buildMethodBuilder.beginControlFlow("if (setFields != 1)", new Object[0]).addStatement("throw new $T($S + setFields + $S)", new Object[]{ClassName.get(IllegalStateException.class), "Invalid union; ", " field(s) were set"}).endControlFlow();
        }
        buildMethodBuilder.addStatement("return new $T(this)", new Object[]{structClassName});
        builder.addMethod(defaultCtor.build());
        builder.addMethod(copyCtor.build());
        builder.addMethod(buildMethodBuilder.build());
        builder.addMethod(resetBuilder.build());
        return builder.build();
    }

    private TypeSpec adapterFor(StructType structType, ClassName structClassName, ClassName builderClassName) {
        ParameterizedTypeName adapterSuperclass = ParameterizedTypeName.get((ClassName)TypeNames.ADAPTER, (TypeName[])new TypeName[]{structClassName, builderClassName});
        MethodSpec.Builder write = MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addParameter((TypeName)structClassName, "struct", new Modifier[0]).addException((TypeName)TypeNames.IO_EXCEPTION);
        MethodSpec.Builder read = MethodSpec.methodBuilder((String)"read").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeResolver.getJavaClass((ThriftType)structType)).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addParameter((TypeName)builderClassName, "builder", new Modifier[0]).addException((TypeName)TypeNames.THRIFT_EXCEPTION).addException((TypeName)TypeNames.IO_EXCEPTION);
        MethodSpec readHelper = MethodSpec.methodBuilder((String)"read").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeResolver.getJavaClass((ThriftType)structType)).addParameter((TypeName)TypeNames.PROTOCOL, "protocol", new Modifier[0]).addException((TypeName)TypeNames.THRIFT_EXCEPTION).addException((TypeName)TypeNames.IO_EXCEPTION).addStatement("return read(protocol, new $T())", new Object[]{builderClassName}).build();
        write.addStatement("protocol.writeStructBegin($S)", new Object[]{structType.name()});
        read.addStatement("protocol.readStructBegin()", new Object[0]);
        read.beginControlFlow("while (true)", new Object[0]);
        read.addStatement("$T field = protocol.readFieldBegin()", new Object[]{TypeNames.FIELD_METADATA});
        read.beginControlFlow("if (field.typeId == $T.STOP)", new Object[]{TypeNames.TTYPE});
        read.addStatement("break", new Object[0]);
        read.endControlFlow();
        if (structType.fields().size() > 0) {
            read.beginControlFlow("switch (field.fieldId)", new Object[0]);
        }
        for (Field field : structType.fields()) {
            String fieldName = this.fieldNamer.getName(field);
            boolean optional = !field.required();
            ThriftType tt = field.type().getTrueType();
            byte typeCode = this.typeResolver.getTypeCode(tt);
            if (typeCode == 16) {
                typeCode = 8;
            }
            String typeCodeName = TypeNames.getTypeCodeName(typeCode);
            if (optional) {
                write.beginControlFlow("if (struct.$N != null)", new Object[]{fieldName});
            }
            write.addStatement("protocol.writeFieldBegin($S, $L, $T.$L)", new Object[]{field.name(), field.id(), TypeNames.TTYPE, typeCodeName});
            tt.accept((ThriftType.Visitor)new GenerateWriterVisitor(this.typeResolver, write, "protocol", "struct", fieldName));
            write.addStatement("protocol.writeFieldEnd()", new Object[0]);
            if (optional) {
                write.endControlFlow();
            }
            read.beginControlFlow("case $L:", new Object[]{field.id()});
            new GenerateReaderVisitor(this.typeResolver, read, fieldName, field.type().getTrueType()).generate();
            read.endControlFlow();
            read.addStatement("break", new Object[0]);
        }
        write.addStatement("protocol.writeFieldStop()", new Object[0]);
        write.addStatement("protocol.writeStructEnd()", new Object[0]);
        if (structType.fields().size() > 0) {
            read.beginControlFlow("default:", new Object[0]);
            read.addStatement("$T.skip(protocol, field.typeId)", new Object[]{TypeNames.PROTO_UTIL});
            read.endControlFlow();
            read.addStatement("break", new Object[0]);
            read.endControlFlow();
        }
        read.addStatement("protocol.readFieldEnd()", new Object[0]);
        read.endControlFlow();
        read.addStatement("protocol.readStructEnd()", new Object[0]);
        read.addStatement("return builder.build()", new Object[0]);
        return TypeSpec.classBuilder((String)(structType.name() + "Adapter")).addSuperinterface((TypeName)adapterSuperclass).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addMethod(write.build()).addMethod(read.build()).addMethod(readHelper).build();
    }

    private MethodSpec buildWrite() {
        return MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Protocol.class, "protocol", new Modifier[0]).addStatement("ADAPTER.write(protocol, this)", new Object[0]).addException((TypeName)TypeNames.IO_EXCEPTION).build();
    }

    private MethodSpec buildEqualsFor(StructType struct) {
        MethodSpec.Builder equals = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "other", new Modifier[0]).addStatement("if (this == other) return true", new Object[0]).addStatement("if (other == null) return false", new Object[0]);
        if (struct.fields().size() > 0) {
            equals.addStatement("if (!(other instanceof $L)) return false", new Object[]{struct.name()});
            equals.addStatement("$1L that = ($1L) other", new Object[]{struct.name()});
        }
        boolean isFirst = true;
        LinkedHashSet<String> warningsToSuppress = new LinkedHashSet<String>();
        for (Field field : struct.fields()) {
            ThriftType type = field.type().getTrueType();
            String fieldName = this.fieldNamer.getName(field);
            if (isFirst) {
                equals.addCode("$[return ", new Object[0]);
                isFirst = false;
            } else {
                equals.addCode("\n&& ", new Object[0]);
            }
            if (field.required()) {
                equals.addCode("(this.$1N == that.$1N || this.$1N.equals(that.$1N))", new Object[]{fieldName});
            } else {
                equals.addCode("(this.$1N == that.$1N || (this.$1N != null && this.$1N.equals(that.$1N)))", new Object[]{fieldName});
            }
            if (type.isBuiltin() && ((BuiltinType)type).isNumeric()) {
                warningsToSuppress.add("NumberEquality");
            }
            if (!type.equals((Object)BuiltinType.STRING)) continue;
            warningsToSuppress.add("StringEquality");
        }
        if (warningsToSuppress.size() > 0) {
            equals.addAnnotation(this.suppressWarnings(warningsToSuppress));
        }
        if (struct.fields().size() > 0) {
            equals.addCode(";\n$]", new Object[0]);
        } else {
            equals.addStatement("return other instanceof $L", new Object[]{struct.name()});
        }
        return equals.build();
    }

    private AnnotationSpec suppressWarnings(Collection<String> warnings) {
        AnnotationSpec.Builder anno = AnnotationSpec.builder(SuppressWarnings.class);
        if (warnings.isEmpty()) {
            throw new IllegalArgumentException("No warnings present - compiler error?");
        }
        if (warnings.size() == 1) {
            anno.addMember("value", "$S", new Object[]{Iterables.get(warnings, (int)0)});
        } else {
            StringBuilder sb = new StringBuilder("{");
            for (String warning : warnings) {
                sb.append("\"");
                sb.append(warning);
                sb.append("\", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
            anno.addMember("value", "$L", new Object[]{sb.toString()});
        }
        return anno.build();
    }

    private MethodSpec buildHashCodeFor(StructType struct) {
        MethodSpec.Builder hashCode = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int code = 16777619", new Object[0]);
        for (Field field : struct.fields()) {
            String fieldName = this.fieldNamer.getName(field);
            if (field.required()) {
                hashCode.addStatement("code ^= this.$N.hashCode()", new Object[]{fieldName});
            } else {
                hashCode.addStatement("code ^= (this.$1N == null) ? 0 : this.$1N.hashCode()", new Object[]{fieldName});
            }
            hashCode.addStatement("code *= 0x811c9dc5", new Object[0]);
        }
        hashCode.addStatement("return code", new Object[0]);
        return hashCode.build();
    }

    private MethodSpec buildToStringFor(StructType struct) {
        MethodSpec.Builder toString = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        class Chunk {
            private final String format;
            private final Object[] args;

            Chunk(String format, Object ... args) {
                this.format = format;
                this.args = args;
            }
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        StringBuilder sb = new StringBuilder(struct.name()).append("{");
        boolean appendedOneField = false;
        for (Field field : struct.fields()) {
            String fieldName = this.fieldNamer.getName(field);
            if (appendedOneField) {
                sb.append(", ");
            } else {
                appendedOneField = true;
            }
            sb.append(fieldName).append("=");
            if (field.isRedacted()) {
                sb.append("<REDACTED>");
                continue;
            }
            if (field.isObfuscated()) {
                Chunk chunk;
                chunks.add(new Chunk("$S", sb.toString()));
                sb.setLength(0);
                ThriftType fieldType = field.type().getTrueType();
                if (fieldType.isList() || fieldType.isSet()) {
                    String elementType;
                    String type;
                    if (fieldType.isList()) {
                        type = "list";
                        elementType = ((ListType)fieldType).elementType().name();
                    } else {
                        type = "set";
                        elementType = ((SetType)fieldType).elementType().name();
                    }
                    chunk = new Chunk("$T.summarizeCollection(this.$L, $S, $S)", TypeNames.OBFUSCATION_UTIL, fieldName, type, elementType);
                } else if (fieldType.isMap()) {
                    MapType mapType = (MapType)fieldType;
                    String keyType = mapType.keyType().name();
                    String valueType = mapType.valueType().name();
                    chunk = new Chunk("$T.summarizeMap(this.$L, $S, $S)", TypeNames.OBFUSCATION_UTIL, fieldName, keyType, valueType);
                } else {
                    chunk = new Chunk("$T.hash(this.$L)", TypeNames.OBFUSCATION_UTIL, fieldName);
                }
                chunks.add(chunk);
                continue;
            }
            chunks.add(new Chunk("$S", sb.toString()));
            chunks.add(new Chunk("this.$L", fieldName));
            sb.setLength(0);
        }
        sb.append("}");
        chunks.add(new Chunk("$S", sb.toString()));
        CodeBlock.Builder block = CodeBlock.builder();
        boolean firstChunk = true;
        for (Chunk chunk : chunks) {
            if (firstChunk) {
                block.add("$[return ", new Object[0]);
                firstChunk = false;
            } else {
                block.add(" + ", new Object[0]);
            }
            block.add(chunk.format, chunk.args);
        }
        block.add(";$]\n", new Object[0]);
        toString.addCode(block.build());
        return toString.build();
    }

    @VisibleForTesting
    TypeSpec buildConst(Collection<Constant> constants) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Constants").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("// no instances\n", new Object[0]).build());
        final NameAllocator allocator = new NameAllocator();
        allocator.newName("Constants", (Object)"Constants");
        final AtomicInteger scope = new AtomicInteger(0);
        final CodeBlock.Builder staticInit = CodeBlock.builder();
        final AtomicBoolean hasStaticInit = new AtomicBoolean(false);
        for (final Constant constant : constants) {
            final ThriftType type = constant.type().getTrueType();
            TypeName javaType = this.typeResolver.getJavaClass(type);
            if (type.isBuiltin() && !type.equals((Object)BuiltinType.STRING)) {
                javaType = javaType.unbox();
            }
            final FieldSpec.Builder field = FieldSpec.builder((TypeName)javaType, (String)constant.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            if (constant.hasJavadoc()) {
                field.addJavadoc("$L", new Object[]{constant.documentation() + "\n\nGenerated from: " + constant.location() + "\n"});
            }
            if (constant.isDeprecated()) {
                field.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
            }
            type.accept((ThriftType.Visitor)new SimpleVisitor<Void>(){

                @Override
                public Void visitBuiltin(ThriftType builtinType) {
                    field.initializer(ThriftyCodeGenerator.this.constantBuilder.renderConstValue(null, allocator, scope, type, constant.value()));
                    return null;
                }

                public Void visitEnum(EnumType userType) {
                    field.initializer(ThriftyCodeGenerator.this.constantBuilder.renderConstValue(null, allocator, scope, type, constant.value()));
                    return null;
                }

                public Void visitList(ListType listType) {
                    if (constant.value().getAsList().isEmpty()) {
                        field.initializer("$T.emptyList()", new Object[]{TypeNames.COLLECTIONS});
                        return null;
                    }
                    this.initCollection("list", "unmodifiableList");
                    return null;
                }

                public Void visitSet(SetType setType) {
                    if (constant.value().getAsList().isEmpty()) {
                        field.initializer("$T.emptySet()", new Object[]{TypeNames.COLLECTIONS});
                        return null;
                    }
                    this.initCollection("set", "unmodifiableSet");
                    return null;
                }

                public Void visitMap(MapType mapType) {
                    if (constant.value().getAsMap().isEmpty()) {
                        field.initializer("$T.emptyMap()", new Object[]{TypeNames.COLLECTIONS});
                        return null;
                    }
                    this.initCollection("map", "unmodifiableMap");
                    return null;
                }

                private void initCollection(String tempName, String unmodifiableMethod) {
                    tempName = tempName + scope.incrementAndGet();
                    ThriftyCodeGenerator.this.constantBuilder.generateFieldInitializer(staticInit, allocator, scope, tempName, type, constant.value(), true);
                    staticInit.addStatement("$N = $T.$L($N)", new Object[]{constant.name(), TypeNames.COLLECTIONS, unmodifiableMethod, tempName});
                    hasStaticInit.set(true);
                }

                public Void visitStruct(StructType userType) {
                    throw new UnsupportedOperationException("Struct-type constants are not supported");
                }

                public Void visitTypedef(TypedefType typedefType) {
                    throw new AssertionError((Object)"Typedefs should have been resolved before now");
                }

                public Void visitService(ServiceType serviceType) {
                    throw new AssertionError((Object)"Services cannot be constant values");
                }
            });
            builder.addField(field.build());
        }
        if (hasStaticInit.get()) {
            builder.addStaticBlock(staticInit.build());
        }
        return builder.build();
    }

    private static AnnotationSpec fieldAnnotation(Field field) {
        String typedef;
        AnnotationSpec.Builder ann = AnnotationSpec.builder(ThriftField.class).addMember("fieldId", "$L", new Object[]{field.id()});
        if (field.required()) {
            ann.addMember("isRequired", "$L", new Object[]{field.required()});
        }
        if (field.optional()) {
            ann.addMember("isOptional", "$L", new Object[]{field.optional()});
        }
        if (!Strings.isNullOrEmpty((String)(typedef = field.typedefName()))) {
            ann = ann.addMember("typedefName", "$S", new Object[]{typedef});
        }
        return ann.build();
    }

    @VisibleForTesting
    TypeSpec buildEnum(EnumType type) {
        ClassName enumClassName = ClassName.get((String)type.getNamespaceFor(NamespaceScope.JAVA), (String)type.name(), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)type.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(Integer.TYPE, "value", new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"value", "value"}).build());
        if (type.hasJavadoc()) {
            builder.addJavadoc("$L", new Object[]{type.documentation()});
        }
        if (type.isDeprecated()) {
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        MethodSpec.Builder fromCodeMethod = MethodSpec.methodBuilder((String)"findByValue").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)enumClassName).addParameter(Integer.TYPE, "value", new Modifier[0]).beginControlFlow("switch (value)", new Object[0]);
        for (EnumMember member : type.members()) {
            String name = member.name();
            int value = member.value();
            TypeSpec.Builder memberBuilder = TypeSpec.anonymousClassBuilder((String)"$L", (Object[])new Object[]{value});
            if (member.hasJavadoc()) {
                memberBuilder.addJavadoc("$L", new Object[]{member.documentation()});
            }
            if (member.isDeprecated()) {
                memberBuilder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
            }
            builder.addEnumConstant(name, memberBuilder.build());
            fromCodeMethod.addStatement("case $L: return $N", new Object[]{value, name});
        }
        fromCodeMethod.addStatement("default: return null", new Object[0]).endControlFlow();
        builder.addMethod(fromCodeMethod.build());
        return builder.build();
    }

    private static interface FileWriter {
        public void write(@Nullable JavaFile var1) throws IOException;
    }
}

