/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0082\bJ\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u000200H\u0016J \u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u0015H\u0016J\u0010\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u0015H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/microsoft/thrifty/gen/GenerateWriterVisitor;", "Lcom/microsoft/thrifty/schema/ThriftType$Visitor;", "", "resolver", "Lcom/microsoft/thrifty/gen/TypeResolver;", "write", "Lcom/squareup/javapoet/MethodSpec$Builder;", "proto", "", "subject", "fieldName", "(Lcom/microsoft/thrifty/gen/TypeResolver;Lcom/squareup/javapoet/MethodSpec$Builder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "nameStack", "Ljava/util/Deque;", "scopeLevel", "", "scope", "fn", "Lkotlin/Function0;", "visitBinary", "binaryType", "Lcom/microsoft/thrifty/schema/BuiltinType;", "visitBool", "boolType", "visitByte", "byteType", "visitDouble", "doubleType", "visitEnum", "enumType", "Lcom/microsoft/thrifty/schema/EnumType;", "visitI16", "i16Type", "visitI32", "i32Type", "visitI64", "i64Type", "visitList", "listType", "Lcom/microsoft/thrifty/schema/ListType;", "visitMap", "mapType", "Lcom/microsoft/thrifty/schema/MapType;", "visitService", "serviceType", "Lcom/microsoft/thrifty/schema/ServiceType;", "visitSet", "setType", "Lcom/microsoft/thrifty/schema/SetType;", "visitSingleElementCollection", "elementType", "Lcom/microsoft/thrifty/schema/ThriftType;", "beginMethod", "endMethod", "visitString", "stringType", "visitStruct", "structType", "Lcom/microsoft/thrifty/schema/StructType;", "visitTypedef", "typedefType", "Lcom/microsoft/thrifty/schema/TypedefType;", "visitVoid", "voidType", "thrifty-java-codegen"})
public final class GenerateWriterVisitor
implements ThriftType.Visitor<Unit> {
    private final Deque<String> nameStack;
    private int scopeLevel;
    private final TypeResolver resolver;
    private final MethodSpec.Builder write;
    private final String proto;

    public void visitBool(@NotNull BuiltinType boolType) {
        Intrinsics.checkParameterIsNotNull((Object)boolType, (String)"boolType");
        this.write.addStatement("$N.writeBool($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitByte(@NotNull BuiltinType byteType) {
        Intrinsics.checkParameterIsNotNull((Object)byteType, (String)"byteType");
        this.write.addStatement("$N.writeByte($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitI16(@NotNull BuiltinType i16Type) {
        Intrinsics.checkParameterIsNotNull((Object)i16Type, (String)"i16Type");
        this.write.addStatement("$N.writeI16($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitI32(@NotNull BuiltinType i32Type) {
        Intrinsics.checkParameterIsNotNull((Object)i32Type, (String)"i32Type");
        this.write.addStatement("$N.writeI32($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitI64(@NotNull BuiltinType i64Type) {
        Intrinsics.checkParameterIsNotNull((Object)i64Type, (String)"i64Type");
        this.write.addStatement("$N.writeI64($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitDouble(@NotNull BuiltinType doubleType) {
        Intrinsics.checkParameterIsNotNull((Object)doubleType, (String)"doubleType");
        this.write.addStatement("$N.writeDouble($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitString(@NotNull BuiltinType stringType) {
        Intrinsics.checkParameterIsNotNull((Object)stringType, (String)"stringType");
        this.write.addStatement("$N.writeString($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitBinary(@NotNull BuiltinType binaryType) {
        Intrinsics.checkParameterIsNotNull((Object)binaryType, (String)"binaryType");
        this.write.addStatement("$N.writeBinary($L)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitVoid(@NotNull BuiltinType voidType) {
        Intrinsics.checkParameterIsNotNull((Object)voidType, (String)"voidType");
        throw (Throwable)((Object)new AssertionError((Object)"Fields cannot be void"));
    }

    public void visitEnum(@NotNull EnumType enumType) {
        Intrinsics.checkParameterIsNotNull((Object)enumType, (String)"enumType");
        this.write.addStatement("$N.writeI32($L.value)", new Object[]{this.proto, this.nameStack.peek()});
    }

    public void visitList(@NotNull ListType listType) {
        Intrinsics.checkParameterIsNotNull((Object)listType, (String)"listType");
        this.visitSingleElementCollection(listType.getElementType().getTrueType(), "writeListBegin", "writeListEnd");
    }

    public void visitSet(@NotNull SetType setType) {
        Intrinsics.checkParameterIsNotNull((Object)setType, (String)"setType");
        this.visitSingleElementCollection(setType.getElementType().getTrueType(), "writeSetBegin", "writeSetEnd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void visitSingleElementCollection(ThriftType elementType, String beginMethod, String endMethod) {
        GenerateWriterVisitor this_$iv;
        String item = "item" + this.scopeLevel;
        TypeName javaClass = this.resolver.getJavaClass(elementType);
        byte typeCode = this.resolver.getTypeCode(elementType);
        String typeCodeName = TypeNames.INSTANCE.getTypeCodeName(typeCode);
        this.write.addStatement("$N.$L($T.$L, $L.size())", new Object[]{this.proto, beginMethod, TypeNames.INSTANCE.getTTYPE(), typeCodeName, this.nameStack.peek()});
        this.write.beginControlFlow("for ($T $N : $L)", new Object[]{javaClass, item, this.nameStack.peek()});
        GenerateWriterVisitor generateWriterVisitor = this_$iv = this;
        int n = generateWriterVisitor.scopeLevel;
        generateWriterVisitor.scopeLevel = n + 1;
        try {
            this.nameStack.push(item);
            elementType.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            GenerateWriterVisitor generateWriterVisitor2 = this_$iv;
            n = generateWriterVisitor2.scopeLevel;
            generateWriterVisitor2.scopeLevel = n + -1;
        }
        this.write.endControlFlow();
        this.write.addStatement("$N.$L()", new Object[]{this.proto, endMethod});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMap(@NotNull MapType mapType) {
        GenerateWriterVisitor this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)mapType, (String)"mapType");
        String entryName = "entry" + this.scopeLevel;
        String keyName = "key" + this.scopeLevel;
        String valueName = "value" + this.scopeLevel;
        ThriftType kt = mapType.getKeyType().getTrueType();
        ThriftType vt = mapType.getValueType().getTrueType();
        byte keyTypeCode = this.resolver.getTypeCode(kt);
        byte valTypeCode = this.resolver.getTypeCode(vt);
        this.write.addStatement("$1N.writeMapBegin($2T.$3L, $2T.$4L, $5L.size())", new Object[]{this.proto, TypeNames.INSTANCE.getTTYPE(), TypeNames.INSTANCE.getTypeCodeName(keyTypeCode), TypeNames.INSTANCE.getTypeCodeName(valTypeCode), this.nameStack.peek()});
        TypeName keyTypeName = this.resolver.getJavaClass(kt);
        TypeName valueTypeName = this.resolver.getJavaClass(vt);
        ParameterizedTypeName entry = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getMAP_ENTRY(), (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        this.write.beginControlFlow("for ($T $N : $L.entrySet())", new Object[]{entry, entryName, this.nameStack.peek()});
        this.write.addStatement("$T $N = $N.getKey()", new Object[]{keyTypeName, keyName, entryName});
        this.write.addStatement("$T $N = $N.getValue()", new Object[]{valueTypeName, valueName, entryName});
        GenerateWriterVisitor generateWriterVisitor = this_$iv = this;
        int n = generateWriterVisitor.scopeLevel;
        generateWriterVisitor.scopeLevel = n + 1;
        try {
            this.nameStack.push(keyName);
            kt.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
            this.nameStack.push(valueName);
            vt.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            GenerateWriterVisitor generateWriterVisitor2 = this_$iv;
            n = generateWriterVisitor2.scopeLevel;
            generateWriterVisitor2.scopeLevel = n + -1;
        }
        this.write.endControlFlow();
        this.write.addStatement("$N.writeMapEnd()", new Object[]{this.proto});
    }

    public void visitStruct(@NotNull StructType structType) {
        Intrinsics.checkParameterIsNotNull((Object)structType, (String)"structType");
        String javaName = structType.getNamespaceFor(new NamespaceScope[]{NamespaceScope.JAVA}) + "." + structType.getName();
        this.write.addStatement("$L.ADAPTER.write($N, $L)", new Object[]{javaName, this.proto, this.nameStack.peek()});
    }

    public void visitTypedef(@NotNull TypedefType typedefType) {
        Intrinsics.checkParameterIsNotNull((Object)typedefType, (String)"typedefType");
        typedefType.getTrueType().accept((ThriftType.Visitor)this);
    }

    public void visitService(@NotNull ServiceType serviceType) {
        Intrinsics.checkParameterIsNotNull((Object)serviceType, (String)"serviceType");
        throw (Throwable)((Object)new AssertionError((Object)"Cannot write a service"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scope(Function0<Unit> fn) {
        GenerateWriterVisitor generateWriterVisitor = this;
        int n = generateWriterVisitor.scopeLevel;
        generateWriterVisitor.scopeLevel = n + 1;
        try {
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            GenerateWriterVisitor generateWriterVisitor2 = this;
            n = generateWriterVisitor2.scopeLevel;
            generateWriterVisitor2.scopeLevel = n + -1;
            InlineMarker.finallyEnd((int)1);
        }
    }

    public GenerateWriterVisitor(@NotNull TypeResolver resolver, @NotNull MethodSpec.Builder write, @NotNull String proto, @NotNull String subject, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Intrinsics.checkParameterIsNotNull((Object)write, (String)"write");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        this.resolver = resolver;
        this.write = write;
        this.proto = proto;
        LinkedList<String> linkedList = new LinkedList<String>();
        GenerateWriterVisitor generateWriterVisitor = this;
        LinkedList<String> $receiver = linkedList;
        $receiver.push(subject + '.' + fieldName);
        LinkedList<String> linkedList2 = linkedList;
        generateWriterVisitor.nameStack = linkedList2;
    }
}

