/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.microsoft.thrifty.schema.UserType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0012\u001a\u00020\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0017\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0082\bJ\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\bH\u0014J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u001dH\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001dH\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020\u001dH\u0016J\u0010\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020\u001dH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/microsoft/thrifty/gen/GenerateReaderVisitor;", "Lcom/microsoft/thrifty/schema/ThriftType$Visitor;", "", "resolver", "Lcom/microsoft/thrifty/gen/TypeResolver;", "read", "Lcom/squareup/javapoet/MethodSpec$Builder;", "fieldName", "", "fieldType", "Lcom/microsoft/thrifty/schema/ThriftType;", "failOnUnknownEnumValues", "", "(Lcom/microsoft/thrifty/gen/TypeResolver;Lcom/squareup/javapoet/MethodSpec$Builder;Ljava/lang/String;Lcom/microsoft/thrifty/schema/ThriftType;Z)V", "nameStack", "Ljava/util/Deque;", "scope", "", "generate", "getFullyQualifiedJavaName", "type", "Lcom/microsoft/thrifty/schema/UserType;", "pushScope", "fn", "Lkotlin/Function0;", "useReadValue", "localName", "visitBinary", "binaryType", "Lcom/microsoft/thrifty/schema/BuiltinType;", "visitBool", "boolType", "visitByte", "byteType", "visitDouble", "doubleType", "visitEnum", "enumType", "Lcom/microsoft/thrifty/schema/EnumType;", "visitI16", "i16Type", "visitI32", "i32Type", "visitI64", "i64Type", "visitList", "listType", "Lcom/microsoft/thrifty/schema/ListType;", "visitMap", "mapType", "Lcom/microsoft/thrifty/schema/MapType;", "visitService", "serviceType", "Lcom/microsoft/thrifty/schema/ServiceType;", "visitSet", "setType", "Lcom/microsoft/thrifty/schema/SetType;", "visitString", "stringType", "visitStruct", "structType", "Lcom/microsoft/thrifty/schema/StructType;", "visitTypedef", "typedefType", "Lcom/microsoft/thrifty/schema/TypedefType;", "visitVoid", "voidType", "thrifty-java-codegen"})
public class GenerateReaderVisitor
implements ThriftType.Visitor<Unit> {
    private final Deque<String> nameStack;
    private int scope;
    private final TypeResolver resolver;
    private final MethodSpec.Builder read;
    private final String fieldName;
    private final ThriftType fieldType;
    private final boolean failOnUnknownEnumValues;

    public final void generate() {
        byte fieldTypeCode = this.resolver.getTypeCode(this.fieldType);
        String codeName = TypeNames.INSTANCE.getTypeCodeName(fieldTypeCode);
        this.read.beginControlFlow("if (field.typeId == $T.$L)", new Object[]{TypeNames.INSTANCE.getTTYPE(), codeName});
        this.nameStack.push("value");
        this.fieldType.accept((ThriftType.Visitor)this);
        this.nameStack.pop();
        this.useReadValue("value");
        this.read.nextControlFlow("else", new Object[0]);
        this.read.addStatement("$T.skip(protocol, field.typeId)", new Object[]{TypeNames.INSTANCE.getPROTO_UTIL()});
        this.read.endControlFlow();
    }

    protected void useReadValue(@NotNull String localName) {
        Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
        if (this.failOnUnknownEnumValues || !this.fieldType.isEnum()) {
            this.read.addStatement("builder.$N($N)", new Object[]{this.fieldName, localName});
        } else {
            this.read.beginControlFlow("if ($N != null)", new Object[]{localName});
            this.read.addStatement("builder.$N($N)", new Object[]{this.fieldName, localName});
            this.read.endControlFlow();
        }
    }

    public void visitBool(@NotNull BuiltinType boolType) {
        Intrinsics.checkParameterIsNotNull((Object)boolType, (String)"boolType");
        this.read.addStatement("$T $N = protocol.readBool()", new Object[]{TypeNames.INSTANCE.getBOOLEAN().unbox(), this.nameStack.peek()});
    }

    public void visitByte(@NotNull BuiltinType byteType) {
        Intrinsics.checkParameterIsNotNull((Object)byteType, (String)"byteType");
        this.read.addStatement("$T $N = protocol.readByte()", new Object[]{TypeNames.INSTANCE.getBYTE().unbox(), this.nameStack.peek()});
    }

    public void visitI16(@NotNull BuiltinType i16Type) {
        Intrinsics.checkParameterIsNotNull((Object)i16Type, (String)"i16Type");
        this.read.addStatement("$T $N = protocol.readI16()", new Object[]{TypeNames.INSTANCE.getSHORT().unbox(), this.nameStack.peek()});
    }

    public void visitI32(@NotNull BuiltinType i32Type) {
        Intrinsics.checkParameterIsNotNull((Object)i32Type, (String)"i32Type");
        this.read.addStatement("$T $N = protocol.readI32()", new Object[]{TypeNames.INSTANCE.getINTEGER().unbox(), this.nameStack.peek()});
    }

    public void visitI64(@NotNull BuiltinType i64Type) {
        Intrinsics.checkParameterIsNotNull((Object)i64Type, (String)"i64Type");
        this.read.addStatement("$T $N = protocol.readI64()", new Object[]{TypeNames.INSTANCE.getLONG().unbox(), this.nameStack.peek()});
    }

    public void visitDouble(@NotNull BuiltinType doubleType) {
        Intrinsics.checkParameterIsNotNull((Object)doubleType, (String)"doubleType");
        this.read.addStatement("$T $N = protocol.readDouble()", new Object[]{TypeNames.INSTANCE.getDOUBLE().unbox(), this.nameStack.peek()});
    }

    public void visitString(@NotNull BuiltinType stringType) {
        Intrinsics.checkParameterIsNotNull((Object)stringType, (String)"stringType");
        this.read.addStatement("$T $N = protocol.readString()", new Object[]{TypeNames.INSTANCE.getSTRING(), this.nameStack.peek()});
    }

    public void visitBinary(@NotNull BuiltinType binaryType) {
        Intrinsics.checkParameterIsNotNull((Object)binaryType, (String)"binaryType");
        this.read.addStatement("$T $N = protocol.readBinary()", new Object[]{TypeNames.INSTANCE.getBYTE_STRING(), this.nameStack.peek()});
    }

    public void visitVoid(@NotNull BuiltinType voidType) {
        Intrinsics.checkParameterIsNotNull((Object)voidType, (String)"voidType");
        throw (Throwable)((Object)new AssertionError((Object)"Cannot read void"));
    }

    public void visitEnum(@NotNull EnumType enumType) {
        Intrinsics.checkParameterIsNotNull((Object)enumType, (String)"enumType");
        String target = this.nameStack.peek();
        String qualifiedJavaName = this.getFullyQualifiedJavaName((UserType)enumType);
        String intName = "i32_" + this.scope;
        this.read.addStatement("int $L = protocol.readI32()", new Object[]{intName});
        this.read.addStatement("$1L $2N = $1L.findByValue($3L)", new Object[]{qualifiedJavaName, target, intName});
        if (this.failOnUnknownEnumValues) {
            Object[] objectArray = new Object[1];
            String string = target;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = string;
            this.read.beginControlFlow("if ($N == null)", objectArray);
            this.read.addStatement("throw new $1T($2T.PROTOCOL_ERROR, $3S + $4L)", new Object[]{TypeNames.INSTANCE.getTHRIFT_EXCEPTION(), TypeNames.INSTANCE.getTHRIFT_EXCEPTION_KIND(), "Unexpected value for enum-type " + enumType.getName() + ": ", intName});
            this.read.endControlFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitList(@NotNull ListType listType) {
        Intrinsics.checkParameterIsNotNull((Object)listType, (String)"listType");
        TypeName elementType = this.resolver.getJavaClass(listType.getElementType().getTrueType());
        ParameterizedTypeName genericListType = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getLIST(), (TypeName[])new TypeName[]{elementType});
        ParameterizedTypeName listImplType = this.resolver.listOf(elementType);
        String listInfo = "listMetadata" + this.scope;
        String idx = "" + 'i' + this.scope;
        String item = "item" + this.scope;
        this.read.addStatement("$T $N = protocol.readListBegin()", new Object[]{TypeNames.INSTANCE.getLIST_META(), listInfo});
        this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericListType, this.nameStack.peek(), listImplType, listInfo});
        this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, listInfo});
        GenerateReaderVisitor this_$iv = this;
        boolean $i$f$pushScope = false;
        GenerateReaderVisitor generateReaderVisitor = this_$iv;
        generateReaderVisitor.scope = generateReaderVisitor.scope + 1;
        generateReaderVisitor.scope;
        try {
            boolean bl = false;
            this.nameStack.push(item);
            listType.getElementType().getTrueType().accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            GenerateReaderVisitor generateReaderVisitor2 = this_$iv;
            generateReaderVisitor2.scope = generateReaderVisitor2.scope + -1;
            generateReaderVisitor2.scope;
        }
        this.read.addStatement("$N.add($N)", new Object[]{this.nameStack.peek(), item});
        this.read.endControlFlow();
        this.read.addStatement("protocol.readListEnd()", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSet(@NotNull SetType setType) {
        Intrinsics.checkParameterIsNotNull((Object)setType, (String)"setType");
        TypeName elementType = this.resolver.getJavaClass(setType.getElementType().getTrueType());
        ParameterizedTypeName genericSetType = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getSET(), (TypeName[])new TypeName[]{elementType});
        ParameterizedTypeName setImplType = this.resolver.setOf(elementType);
        String setInfo = "setMetadata" + this.scope;
        String idx = "" + 'i' + this.scope;
        String item = "item" + this.scope;
        this.read.addStatement("$T $N = protocol.readSetBegin()", new Object[]{TypeNames.INSTANCE.getSET_META(), setInfo});
        this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericSetType, this.nameStack.peek(), setImplType, setInfo});
        this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, setInfo});
        GenerateReaderVisitor this_$iv = this;
        boolean $i$f$pushScope = false;
        GenerateReaderVisitor generateReaderVisitor = this_$iv;
        generateReaderVisitor.scope = generateReaderVisitor.scope + 1;
        generateReaderVisitor.scope;
        try {
            boolean bl = false;
            this.nameStack.push(item);
            setType.getElementType().accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            GenerateReaderVisitor generateReaderVisitor2 = this_$iv;
            generateReaderVisitor2.scope = generateReaderVisitor2.scope + -1;
            generateReaderVisitor2.scope;
        }
        this.read.addStatement("$N.add($N)", new Object[]{this.nameStack.peek(), item});
        this.read.endControlFlow();
        this.read.addStatement("protocol.readSetEnd()", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMap(@NotNull MapType mapType) {
        Intrinsics.checkParameterIsNotNull((Object)mapType, (String)"mapType");
        TypeName keyType = this.resolver.getJavaClass(mapType.getKeyType().getTrueType());
        TypeName valueType = this.resolver.getJavaClass(mapType.getValueType().getTrueType());
        ParameterizedTypeName genericMapType = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getMAP(), (TypeName[])new TypeName[]{keyType, valueType});
        ParameterizedTypeName mapImplType = this.resolver.mapOf(keyType, valueType);
        String mapInfo = "mapMetadata" + this.scope;
        String idx = "" + 'i' + this.scope;
        String key = "key" + this.scope;
        String value = "value" + this.scope;
        GenerateReaderVisitor this_$iv = this;
        boolean $i$f$pushScope = false;
        GenerateReaderVisitor generateReaderVisitor = this_$iv;
        generateReaderVisitor.scope = generateReaderVisitor.scope + 1;
        generateReaderVisitor.scope;
        try {
            boolean bl = false;
            this.read.addStatement("$T $N = protocol.readMapBegin()", new Object[]{TypeNames.INSTANCE.getMAP_META(), mapInfo});
            this.read.addStatement("$T $N = new $T($N.size)", new Object[]{genericMapType, this.nameStack.peek(), mapImplType, mapInfo});
            this.read.beginControlFlow("for (int $1N = 0; $1N < $2N.size; ++$1N)", new Object[]{idx, mapInfo});
            this.nameStack.push(key);
            mapType.getKeyType().accept((ThriftType.Visitor)this);
            this.nameStack.pop();
            GenerateReaderVisitor this_$iv2 = this;
            boolean $i$f$pushScope2 = false;
            GenerateReaderVisitor generateReaderVisitor2 = this_$iv2;
            generateReaderVisitor2.scope = generateReaderVisitor2.scope + 1;
            generateReaderVisitor2.scope;
            try {
                boolean bl2 = false;
                this.nameStack.push(value);
                mapType.getValueType().accept((ThriftType.Visitor)this);
                this.nameStack.pop();
            }
            finally {
                GenerateReaderVisitor generateReaderVisitor3 = this_$iv2;
                generateReaderVisitor3.scope = generateReaderVisitor3.scope + -1;
                generateReaderVisitor3.scope;
            }
            this.read.addStatement("$N.put($N, $N)", new Object[]{this.nameStack.peek(), key, value});
            this.read.endControlFlow();
            this.read.addStatement("protocol.readMapEnd()", new Object[0]);
        }
        finally {
            GenerateReaderVisitor generateReaderVisitor4 = this_$iv;
            generateReaderVisitor4.scope = generateReaderVisitor4.scope + -1;
            generateReaderVisitor4.scope;
        }
    }

    public void visitStruct(@NotNull StructType structType) {
        Intrinsics.checkParameterIsNotNull((Object)structType, (String)"structType");
        String qualifiedJavaName = this.getFullyQualifiedJavaName((UserType)structType);
        this.read.addStatement("$1L $2N = $1L.ADAPTER.read(protocol)", new Object[]{qualifiedJavaName, this.nameStack.peek()});
    }

    public void visitTypedef(@NotNull TypedefType typedefType) {
        Intrinsics.checkParameterIsNotNull((Object)typedefType, (String)"typedefType");
        typedefType.getTrueType().accept((ThriftType.Visitor)this);
    }

    public void visitService(@NotNull ServiceType serviceType) {
        Intrinsics.checkParameterIsNotNull((Object)serviceType, (String)"serviceType");
        throw (Throwable)((Object)new AssertionError((Object)"Cannot read a service"));
    }

    private final String getFullyQualifiedJavaName(UserType type) {
        if (type.isBuiltin() || type.isList() || type.isMap() || type.isSet() || type.isTypedef()) {
            throw (Throwable)((Object)new AssertionError((Object)"Only user and enum types are supported"));
        }
        String packageName = type.getNamespaceFor(new NamespaceScope[]{NamespaceScope.JAVA});
        return packageName + "." + type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pushScope(Function0<Unit> fn) {
        int $i$f$pushScope = 0;
        GenerateReaderVisitor generateReaderVisitor = this;
        generateReaderVisitor.scope = generateReaderVisitor.scope + 1;
        generateReaderVisitor.scope;
        try {
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            GenerateReaderVisitor generateReaderVisitor2 = this;
            generateReaderVisitor2.scope = generateReaderVisitor2.scope + -1;
            generateReaderVisitor2.scope;
            InlineMarker.finallyEnd((int)1);
        }
    }

    public GenerateReaderVisitor(@NotNull TypeResolver resolver, @NotNull MethodSpec.Builder read, @NotNull String fieldName, @NotNull ThriftType fieldType, boolean failOnUnknownEnumValues) {
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Intrinsics.checkParameterIsNotNull((Object)read, (String)"read");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)fieldType, (String)"fieldType");
        this.resolver = resolver;
        this.read = read;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.failOnUnknownEnumValues = failOnUnknownEnumValues;
        this.nameStack = new ArrayDeque();
    }

    public /* synthetic */ GenerateReaderVisitor(TypeResolver typeResolver, MethodSpec.Builder builder, String string, ThriftType thriftType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(typeResolver, builder, string, thriftType, bl);
    }
}

