/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0082\bJ\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u000200H\u0016J \u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u0015H\u0016J\u0010\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u0015H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/microsoft/thrifty/gen/GenerateWriterVisitor;", "Lcom/microsoft/thrifty/schema/ThriftType$Visitor;", "", "resolver", "Lcom/microsoft/thrifty/gen/TypeResolver;", "write", "Lcom/squareup/javapoet/MethodSpec$Builder;", "proto", "", "subject", "fieldName", "(Lcom/microsoft/thrifty/gen/TypeResolver;Lcom/squareup/javapoet/MethodSpec$Builder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "nameStack", "Ljava/util/Deque;", "scopeLevel", "", "scope", "fn", "Lkotlin/Function0;", "visitBinary", "binaryType", "Lcom/microsoft/thrifty/schema/BuiltinType;", "visitBool", "boolType", "visitByte", "byteType", "visitDouble", "doubleType", "visitEnum", "enumType", "Lcom/microsoft/thrifty/schema/EnumType;", "visitI16", "i16Type", "visitI32", "i32Type", "visitI64", "i64Type", "visitList", "listType", "Lcom/microsoft/thrifty/schema/ListType;", "visitMap", "mapType", "Lcom/microsoft/thrifty/schema/MapType;", "visitService", "serviceType", "Lcom/microsoft/thrifty/schema/ServiceType;", "visitSet", "setType", "Lcom/microsoft/thrifty/schema/SetType;", "visitSingleElementCollection", "elementType", "Lcom/microsoft/thrifty/schema/ThriftType;", "beginMethod", "endMethod", "visitString", "stringType", "visitStruct", "structType", "Lcom/microsoft/thrifty/schema/StructType;", "visitTypedef", "typedefType", "Lcom/microsoft/thrifty/schema/TypedefType;", "visitVoid", "voidType", "thrifty-java-codegen"})
public final class GenerateWriterVisitor
implements ThriftType.Visitor<Unit> {
    @NotNull
    private final TypeResolver resolver;
    @NotNull
    private final MethodSpec.Builder write;
    @NotNull
    private final String proto;
    @NotNull
    private final Deque<String> nameStack;
    private int scopeLevel;

    /*
     * WARNING - void declaration
     */
    public GenerateWriterVisitor(@NotNull TypeResolver resolver, @NotNull MethodSpec.Builder write, @NotNull String proto, @NotNull String subject, @NotNull String fieldName) {
        void $this$nameStack_u24lambda_u240;
        LinkedList linkedList;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)write, (String)"write");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        this.resolver = resolver;
        this.write = write;
        this.proto = proto;
        LinkedList linkedList2 = linkedList = new LinkedList();
        GenerateWriterVisitor generateWriterVisitor = this;
        boolean bl = false;
        $this$nameStack_u24lambda_u240.push(subject + '.' + fieldName);
        generateWriterVisitor.nameStack = linkedList;
    }

    public void visitBool(@NotNull BuiltinType boolType) {
        Intrinsics.checkNotNullParameter((Object)boolType, (String)"boolType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeBool($L)", objectArray);
    }

    public void visitByte(@NotNull BuiltinType byteType) {
        Intrinsics.checkNotNullParameter((Object)byteType, (String)"byteType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeByte($L)", objectArray);
    }

    public void visitI16(@NotNull BuiltinType i16Type) {
        Intrinsics.checkNotNullParameter((Object)i16Type, (String)"i16Type");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeI16($L)", objectArray);
    }

    public void visitI32(@NotNull BuiltinType i32Type) {
        Intrinsics.checkNotNullParameter((Object)i32Type, (String)"i32Type");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeI32($L)", objectArray);
    }

    public void visitI64(@NotNull BuiltinType i64Type) {
        Intrinsics.checkNotNullParameter((Object)i64Type, (String)"i64Type");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeI64($L)", objectArray);
    }

    public void visitDouble(@NotNull BuiltinType doubleType) {
        Intrinsics.checkNotNullParameter((Object)doubleType, (String)"doubleType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeDouble($L)", objectArray);
    }

    public void visitString(@NotNull BuiltinType stringType) {
        Intrinsics.checkNotNullParameter((Object)stringType, (String)"stringType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeString($L)", objectArray);
    }

    public void visitBinary(@NotNull BuiltinType binaryType) {
        Intrinsics.checkNotNullParameter((Object)binaryType, (String)"binaryType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeBinary($L)", objectArray);
    }

    public void visitVoid(@NotNull BuiltinType voidType) {
        Intrinsics.checkNotNullParameter((Object)voidType, (String)"voidType");
        throw new AssertionError((Object)"Fields cannot be void");
    }

    public void visitEnum(@NotNull EnumType enumType) {
        Intrinsics.checkNotNullParameter((Object)enumType, (String)"enumType");
        Object[] objectArray = new Object[]{this.proto, this.nameStack.peek()};
        this.write.addStatement("$N.writeI32($L.value)", objectArray);
    }

    public void visitList(@NotNull ListType listType) {
        Intrinsics.checkNotNullParameter((Object)listType, (String)"listType");
        this.visitSingleElementCollection(listType.getElementType().getTrueType(), "writeListBegin", "writeListEnd");
    }

    public void visitSet(@NotNull SetType setType) {
        Intrinsics.checkNotNullParameter((Object)setType, (String)"setType");
        this.visitSingleElementCollection(setType.getElementType().getTrueType(), "writeSetBegin", "writeSetEnd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void visitSingleElementCollection(ThriftType elementType, String beginMethod, String endMethod) {
        String item = "item" + this.scopeLevel;
        TypeName javaClass = this.resolver.getJavaClass(elementType);
        byte typeCode = this.resolver.getTypeCode(elementType);
        String typeCodeName = TypeNames.INSTANCE.getTypeCodeName(typeCode);
        Object[] objectArray = new Object[]{this.proto, beginMethod, TypeNames.INSTANCE.getTTYPE(), typeCodeName, this.nameStack.peek()};
        this.write.addStatement("$N.$L($T.$L, $L.size())", objectArray);
        objectArray = new Object[]{javaClass, item, this.nameStack.peek()};
        this.write.beginControlFlow("for ($T $N : $L)", objectArray);
        GenerateWriterVisitor this_$iv = this;
        boolean $i$f$scope = false;
        int n = this_$iv.scopeLevel;
        this_$iv.scopeLevel = n + 1;
        try {
            boolean bl = false;
            this.nameStack.push(item);
            elementType.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            n = this_$iv.scopeLevel;
            this_$iv.scopeLevel = n + -1;
        }
        this.write.endControlFlow();
        objectArray = new Object[]{this.proto, endMethod};
        this.write.addStatement("$N.$L()", objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMap(@NotNull MapType mapType) {
        Intrinsics.checkNotNullParameter((Object)mapType, (String)"mapType");
        String entryName = "entry" + this.scopeLevel;
        String keyName = "key" + this.scopeLevel;
        String valueName = "value" + this.scopeLevel;
        ThriftType kt = mapType.getKeyType().getTrueType();
        ThriftType vt = mapType.getValueType().getTrueType();
        byte keyTypeCode = this.resolver.getTypeCode(kt);
        byte valTypeCode = this.resolver.getTypeCode(vt);
        Object[] objectArray = new Object[]{this.proto, TypeNames.INSTANCE.getTTYPE(), TypeNames.INSTANCE.getTypeCodeName(keyTypeCode), TypeNames.INSTANCE.getTypeCodeName(valTypeCode), this.nameStack.peek()};
        this.write.addStatement("$1N.writeMapBegin($2T.$3L, $2T.$4L, $5L.size())", objectArray);
        TypeName keyTypeName = this.resolver.getJavaClass(kt);
        TypeName valueTypeName = this.resolver.getJavaClass(vt);
        Object[] objectArray2 = new TypeName[]{keyTypeName, valueTypeName};
        ParameterizedTypeName entry = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getMAP_ENTRY(), (TypeName[])objectArray2);
        objectArray2 = new Object[]{entry, entryName, this.nameStack.peek()};
        this.write.beginControlFlow("for ($T $N : $L.entrySet())", objectArray2);
        objectArray2 = new Object[]{keyTypeName, keyName, entryName};
        this.write.addStatement("$T $N = $N.getKey()", objectArray2);
        objectArray2 = new Object[]{valueTypeName, valueName, entryName};
        this.write.addStatement("$T $N = $N.getValue()", objectArray2);
        GenerateWriterVisitor this_$iv = this;
        boolean $i$f$scope = false;
        int n = this_$iv.scopeLevel;
        this_$iv.scopeLevel = n + 1;
        try {
            boolean bl = false;
            this.nameStack.push(keyName);
            kt.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
            this.nameStack.push(valueName);
            vt.accept((ThriftType.Visitor)this);
            this.nameStack.pop();
        }
        finally {
            n = this_$iv.scopeLevel;
            this_$iv.scopeLevel = n + -1;
        }
        this.write.endControlFlow();
        objectArray2 = new Object[]{this.proto};
        this.write.addStatement("$N.writeMapEnd()", objectArray2);
    }

    public void visitStruct(@NotNull StructType structType) {
        Intrinsics.checkNotNullParameter((Object)structType, (String)"structType");
        Object[] objectArray = new NamespaceScope[]{NamespaceScope.JAVA};
        String javaName = structType.getNamespaceFor((NamespaceScope[])objectArray) + '.' + structType.getName();
        objectArray = new Object[]{javaName, this.proto, this.nameStack.peek()};
        this.write.addStatement("$L.ADAPTER.write($N, $L)", objectArray);
    }

    public void visitTypedef(@NotNull TypedefType typedefType) {
        Intrinsics.checkNotNullParameter((Object)typedefType, (String)"typedefType");
        typedefType.getTrueType().accept((ThriftType.Visitor)this);
    }

    public void visitService(@NotNull ServiceType serviceType) {
        Intrinsics.checkNotNullParameter((Object)serviceType, (String)"serviceType");
        throw new AssertionError((Object)"Cannot write a service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scope(Function0<Unit> fn) {
        boolean $i$f$scope = false;
        int n = this.scopeLevel;
        this.scopeLevel = n + 1;
        try {
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n = this.scopeLevel;
            this.scopeLevel = n + -1;
            InlineMarker.finallyEnd((int)1);
        }
    }
}

