/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gen;

import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.gen.ConstantBuilder;
import com.microsoft.thrifty.gen.FieldNamer;
import com.microsoft.thrifty.gen.GenerateReaderVisitor;
import com.microsoft.thrifty.gen.GenerateWriterVisitor;
import com.microsoft.thrifty.gen.TypeNames;
import com.microsoft.thrifty.gen.TypeResolver;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.Field;
import com.microsoft.thrifty.schema.NamespaceScope;
import com.microsoft.thrifty.schema.ServiceMethod;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.parser.ConstValueElement;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Modifier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/microsoft/thrifty/gen/ServiceBuilder;", "", "typeResolver", "Lcom/microsoft/thrifty/gen/TypeResolver;", "constantBuilder", "Lcom/microsoft/thrifty/gen/ConstantBuilder;", "fieldNamer", "Lcom/microsoft/thrifty/gen/FieldNamer;", "(Lcom/microsoft/thrifty/gen/TypeResolver;Lcom/microsoft/thrifty/gen/ConstantBuilder;Lcom/microsoft/thrifty/gen/FieldNamer;)V", "buildCallCtor", "Lcom/squareup/javapoet/MethodSpec;", "method", "Lcom/microsoft/thrifty/schema/ServiceMethod;", "callbackTypeName", "Lcom/squareup/javapoet/TypeName;", "buildCallSpec", "Lcom/squareup/javapoet/TypeSpec;", "buildReceiveMethod", "hasReturnType", "", "buildSendMethod", "buildService", "service", "Lcom/microsoft/thrifty/schema/ServiceType;", "serviceInterface", "buildServiceInterface", "thrifty-java-codegen"})
public final class ServiceBuilder {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final ConstantBuilder constantBuilder;
    @NotNull
    private final FieldNamer fieldNamer;

    public ServiceBuilder(@NotNull TypeResolver typeResolver, @NotNull ConstantBuilder constantBuilder, @NotNull FieldNamer fieldNamer) {
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)constantBuilder, (String)"constantBuilder");
        Intrinsics.checkNotNullParameter((Object)fieldNamer, (String)"fieldNamer");
        this.typeResolver = typeResolver;
        this.constantBuilder = constantBuilder;
        this.fieldNamer = fieldNamer;
    }

    @NotNull
    public final TypeSpec buildServiceInterface(@NotNull ServiceType service) {
        Object superTypeName;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder serviceSpec = TypeSpec.interfaceBuilder((String)service.getName()).addModifiers(modifierArray);
        String it = service.getDocumentation();
        boolean bl = false;
        if (((CharSequence)it).length() > 0) {
            serviceSpec.addJavadoc(it, new Object[0]);
        }
        if (service.isDeprecated()) {
            serviceSpec.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        ThriftType thriftType = service.getExtendsService();
        if (thriftType != null) {
            ThriftType it2 = thriftType;
            boolean bl2 = false;
            ThriftType superType = it2.getTrueType();
            superTypeName = this.typeResolver.getJavaClass(superType);
            serviceSpec.addSuperinterface((TypeName)superTypeName);
        }
        for (ServiceMethod method : service.getMethods()) {
            NameAllocator allocator = new NameAllocator();
            int tag = 0;
            superTypeName = new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT};
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getName()).addModifiers((Modifier[])superTypeName);
            if (method.getHasJavadoc()) {
                methodBuilder.addJavadoc(method.getDocumentation(), new Object[0]);
            }
            for (Field field : method.getParameters()) {
                String fieldName = this.fieldNamer.getName(field);
                String name = allocator.newName(fieldName, (Object)(++tag));
                ThriftType paramType = field.getType().getTrueType();
                TypeName paramTypeName = this.typeResolver.getJavaClass(paramType);
                methodBuilder.addParameter(paramTypeName, name, new Modifier[0]);
            }
            String callbackName = allocator.newName("callback", (Object)(++tag));
            ThriftType returnType = method.getReturnType();
            TypeName returnTypeName = Intrinsics.areEqual((Object)returnType, (Object)BuiltinType.Companion.getVOID()) ? (TypeName)ClassName.get((String)"kotlin", (String)"Unit", (String[])new String[0]) : this.typeResolver.getJavaClass(returnType.getTrueType());
            TypeName[] typeNameArray = new TypeName[]{returnTypeName};
            ParameterizedTypeName callbackInterfaceName = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getSERVICE_CALLBACK(), (TypeName[])typeNameArray);
            methodBuilder.addParameter((TypeName)callbackInterfaceName, callbackName, new Modifier[0]);
            serviceSpec.addMethod(methodBuilder.build());
        }
        TypeSpec typeSpec = serviceSpec.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"serviceSpec.build()");
        return typeSpec;
    }

    @NotNull
    public final TypeSpec buildService(@NotNull ServiceType service, @NotNull TypeSpec serviceInterface) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)serviceInterface, (String)"serviceInterface");
        NamespaceScope[] namespaceScopeArray = new NamespaceScope[]{NamespaceScope.JAVA};
        String packageName = service.getNamespaceFor(namespaceScopeArray);
        ClassName interfaceTypeName = ClassName.get((String)packageName, (String)serviceInterface.name, (String[])new String[0]);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(service.getName() + "Client")).addModifiers(modifierArray).addSuperinterface((TypeName)interfaceTypeName);
        ThriftType extendsServiceType = service.getExtendsService();
        if (extendsServiceType instanceof ServiceType) {
            String typeName = ((ServiceType)extendsServiceType).getName() + "Client";
            NamespaceScope[] namespaceScopeArray2 = new NamespaceScope[]{NamespaceScope.JAVA};
            String ns = ((ServiceType)extendsServiceType).getNamespaceFor(namespaceScopeArray2);
            ClassName javaClass = ClassName.get((String)ns, (String)typeName, (String[])new String[0]);
            builder.superclass((TypeName)javaClass);
        } else {
            builder.superclass((TypeName)TypeNames.INSTANCE.getSERVICE_CLIENT_BASE());
        }
        Object object = new Modifier[]{Modifier.PUBLIC};
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers((Modifier[])object).addParameter((TypeName)TypeNames.INSTANCE.getPROTOCOL(), "protocol", new Modifier[0]).addParameter((TypeName)TypeNames.INSTANCE.getSERVICE_CLIENT_LISTENER(), "listener", new Modifier[0]).addStatement("super(protocol, listener)", new Object[0]).build());
        object = serviceInterface.methodSpecs.iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            MethodSpec methodSpec = (MethodSpec)object.next();
            ServiceMethod serviceMethod = (ServiceMethod)service.getMethods().get(i);
            TypeSpec call = this.buildCallSpec(serviceMethod);
            builder.addType(call);
            Modifier[] modifierArray2 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder meth = MethodSpec.methodBuilder((String)methodSpec.name).addAnnotation(Override.class).addModifiers(modifierArray2).addParameters((Iterable)methodSpec.parameters).addExceptions((Iterable)methodSpec.exceptions);
            Object object2 = new Object[]{call};
            CodeBlock.Builder body = CodeBlock.builder().add("$[this.enqueue(new $N(", (Object[])object2);
            object2 = methodSpec.parameters.iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                Object[] objectArray;
                int index = n2++;
                ParameterSpec parameter = (ParameterSpec)object2.next();
                if (index == 0) {
                    objectArray = new Object[]{parameter.name};
                    body.add("$N", objectArray);
                    continue;
                }
                objectArray = new Object[]{parameter.name};
                body.add(", $N", objectArray);
            }
            body.add("));\n$]", new Object[0]);
            meth.addCode(body.build());
            builder.addMethod(meth.build());
        }
        TypeSpec typeSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"builder.build()");
        return typeSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec buildCallSpec(ServiceMethod method) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = method.getName();
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it22;
            char c2 = string2.charAt(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = stringBuilder;
            int n = 0;
            if (Character.isLowerCase((char)it22)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                string3 = CharsKt.titlecase((char)it22, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it22);
            }
            String string4 = string3;
            stringBuilder = stringBuilder3;
            StringBuilder stringBuilder4 = stringBuilder2.append((Object)string4);
            String it22 = string2;
            n = 1;
            String string5 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder4.append(string5).toString();
        } else {
            string = string2;
        }
        String name = stringBuilder.append(string).append("Call").toString();
        ThriftType returnType = method.getReturnType();
        TypeName returnTypeName = Intrinsics.areEqual((Object)returnType, (Object)BuiltinType.Companion.getVOID()) ? (TypeName)ClassName.get((String)"kotlin", (String)"Unit", (String[])new String[0]) : this.typeResolver.getJavaClass(returnType.getTrueType());
        TypeName[] typeNameArray = new TypeName[]{returnTypeName};
        ParameterizedTypeName callbackTypeName = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getSERVICE_CALLBACK(), (TypeName[])typeNameArray);
        TypeName[] typeNameArray2 = new TypeName[]{returnTypeName};
        ParameterizedTypeName superclass = ParameterizedTypeName.get((ClassName)TypeNames.INSTANCE.getSERVICE_METHOD_CALL(), (TypeName[])typeNameArray2);
        boolean hasReturnType = !Intrinsics.areEqual((Object)returnType, (Object)BuiltinType.Companion.getVOID());
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL};
        TypeSpec.Builder callBuilder = TypeSpec.classBuilder((String)name).addModifiers(modifierArray).superclass((TypeName)superclass);
        for (Field field : method.getParameters()) {
            TypeName javaType = this.typeResolver.getJavaClass(field.getType().getTrueType());
            Modifier[] modifierArray2 = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
            callBuilder.addField(FieldSpec.builder((TypeName)javaType, (String)this.fieldNamer.getName(field), (Modifier[])new Modifier[0]).addModifiers(modifierArray2).build());
        }
        Intrinsics.checkNotNullExpressionValue((Object)callbackTypeName, (String)"callbackTypeName");
        callBuilder.addMethod(this.buildCallCtor(method, (TypeName)callbackTypeName));
        callBuilder.addMethod(this.buildSendMethod(method));
        callBuilder.addMethod(this.buildReceiveMethod(method, hasReturnType));
        TypeSpec typeSpec = callBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"callBuilder.build()");
        return typeSpec;
    }

    private final MethodSpec buildCallCtor(ServiceMethod method, TypeName callbackTypeName) {
        NameAllocator allocator = new NameAllocator();
        AtomicInteger scope = new AtomicInteger(0);
        Object[] objectArray = new Object[]{method.getName(), TypeNames.INSTANCE.getTMESSAGE_TYPE(), method.getOneWay() ? "ONEWAY" : "CALL"};
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addStatement("super($S, $T.$L, callback)", objectArray);
        for (Field field : method.getParameters()) {
            Object[] objectArray2;
            String fieldName = this.fieldNamer.getName(field);
            TypeName javaType = this.typeResolver.getJavaClass(field.getType().getTrueType());
            ctor.addParameter(javaType, fieldName, new Modifier[0]);
            if (field.getRequired() && field.getDefaultValue() == null) {
                objectArray2 = new Object[]{fieldName, fieldName};
                ctor.addStatement("if ($L == null) throw new NullPointerException($S)", objectArray2);
                objectArray2 = new Object[]{fieldName};
                ctor.addStatement("this.$1L = $1L", objectArray2);
                continue;
            }
            if (field.getDefaultValue() != null) {
                objectArray2 = new Object[]{fieldName};
                ctor.beginControlFlow("if ($L != null)", objectArray2);
                objectArray2 = new Object[]{fieldName};
                ctor.addStatement("this.$1L = $1L", objectArray2);
                ctor.nextControlFlow("else", new Object[0]);
                CodeBlock.Builder init = CodeBlock.builder();
                Intrinsics.checkNotNullExpressionValue((Object)init, (String)"init");
                String string = "this." + fieldName;
                ThriftType thriftType = field.getType().getTrueType();
                ConstValueElement constValueElement = field.getDefaultValue();
                Intrinsics.checkNotNull((Object)constValueElement);
                this.constantBuilder.generateFieldInitializer(init, allocator, scope, string, thriftType, constValueElement, false);
                ctor.addCode(init.build());
                ctor.endControlFlow();
                continue;
            }
            objectArray2 = new Object[]{fieldName};
            ctor.addStatement("this.$1L = $1L", objectArray2);
        }
        ctor.addParameter(callbackTypeName, "callback", new Modifier[0]);
        MethodSpec methodSpec = ctor.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"ctor.build()");
        return methodSpec;
    }

    private final MethodSpec buildSendMethod(ServiceMethod method) {
        Object object = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder send = MethodSpec.methodBuilder((String)"send").addAnnotation(Override.class).addModifiers((Modifier[])object).addParameter((TypeName)TypeNames.INSTANCE.getPROTOCOL(), "protocol", new Modifier[0]).addException((TypeName)TypeNames.INSTANCE.getIO_EXCEPTION());
        object = new Object[]{"args"};
        send.addStatement("protocol.writeStructBegin($S)", (Object[])object);
        for (Field field : method.getParameters()) {
            Object[] objectArray;
            String fieldName = this.fieldNamer.getName(field);
            boolean optional = !field.getRequired();
            ThriftType tt = field.getType().getTrueType();
            byte typeCode = this.typeResolver.getTypeCode(tt);
            if (optional) {
                objectArray = new Object[]{fieldName};
                send.beginControlFlow("if (this.$L != null)", objectArray);
            }
            objectArray = new Object[]{field.getName(), field.getId(), TypeNames.INSTANCE.getTTYPE(), TypeNames.INSTANCE.getTypeCodeName(typeCode)};
            send.addStatement("protocol.writeFieldBegin($S, $L, $T.$L)", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)send, (String)"send");
            tt.accept((ThriftType.Visitor)new GenerateWriterVisitor(this.typeResolver, send, "protocol", "this", fieldName));
            send.addStatement("protocol.writeFieldEnd()", new Object[0]);
            if (!optional) continue;
            send.endControlFlow();
        }
        send.addStatement("protocol.writeFieldStop()", new Object[0]);
        send.addStatement("protocol.writeStructEnd()", new Object[0]);
        MethodSpec methodSpec = send.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"send.build()");
        return methodSpec;
    }

    private final MethodSpec buildReceiveMethod(ServiceMethod method, boolean hasReturnType) {
        Object type;
        Object[] objectArray;
        Object exceptionTypeName;
        String fieldName;
        Object object;
        Object retTypeName;
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder recv = MethodSpec.methodBuilder((String)"receive").addAnnotation(Override.class).addModifiers(modifierArray).addParameter((TypeName)TypeNames.INSTANCE.getPROTOCOL(), "protocol", new Modifier[0]).addParameter((TypeName)TypeNames.INSTANCE.getMESSAGE_METADATA(), "metadata", new Modifier[0]).addException((TypeName)TypeNames.INSTANCE.getEXCEPTION());
        if (hasReturnType) {
            retTypeName = this.typeResolver.getJavaClass(method.getReturnType().getTrueType());
            recv.returns((TypeName)retTypeName);
            object = new Object[]{retTypeName};
            recv.addStatement("$T result = null", (Object[])object);
        } else {
            recv.returns((TypeName)ClassName.get((String)"kotlin", (String)"Unit", (String[])new String[0]));
        }
        for (Object field : method.getExceptions()) {
            fieldName = this.fieldNamer.getName((Field)field);
            exceptionTypeName = this.typeResolver.getJavaClass(field.getType().getTrueType());
            objectArray = new Object[]{exceptionTypeName, fieldName};
            recv.addStatement("$T $L = null", objectArray);
        }
        retTypeName = new Object[]{TypeNames.INSTANCE.getFIELD_METADATA()};
        MethodSpec.Builder builder = recv.addStatement("protocol.readStructBegin()", new Object[0]).beginControlFlow("while (true)", new Object[0]).addStatement("$T field = protocol.readFieldBegin()", (Object[])retTypeName);
        retTypeName = new Object[]{TypeNames.INSTANCE.getTTYPE()};
        builder.beginControlFlow("if (field.typeId == $T.STOP)", (Object[])retTypeName).addStatement("break", new Object[0]).endControlFlow().beginControlFlow("switch (field.fieldId)", new Object[0]);
        if (hasReturnType) {
            Object field;
            type = method.getReturnType().getTrueType();
            recv.beginControlFlow("case 0:", new Object[0]);
            field = this.typeResolver;
            new GenerateReaderVisitor(recv, (ThriftType)type, (TypeResolver)field){
                final /* synthetic */ MethodSpec.Builder $recv;
                {
                    this.$recv = $recv;
                    Intrinsics.checkNotNullExpressionValue((Object)$recv, (String)"recv");
                    super($super_call_param$1, $recv, "result", $type, false, 16, null);
                }

                protected void useReadValue(@NotNull String localName) {
                    Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                    Object[] objectArray = new Object[]{localName};
                    this.$recv.addStatement("result = $N", objectArray);
                }
            }.generate();
            recv.endControlFlow();
            recv.addStatement("break", new Object[0]);
        }
        for (Object field : method.getExceptions()) {
            fieldName = this.fieldNamer.getName((Field)field);
            exceptionTypeName = new Object[]{field.getId()};
            recv.beginControlFlow("case $L:", exceptionTypeName);
            exceptionTypeName = this.typeResolver;
            objectArray = field.getType().getTrueType();
            new GenerateReaderVisitor(recv, fieldName, (TypeResolver)exceptionTypeName, (ThriftType)objectArray){
                final /* synthetic */ MethodSpec.Builder $recv;
                final /* synthetic */ String $fieldName;
                {
                    this.$recv = $recv;
                    this.$fieldName = $fieldName;
                    Intrinsics.checkNotNullExpressionValue((Object)$recv, (String)"recv");
                    super($super_call_param$1, $recv, $fieldName, $super_call_param$2, false, 16, null);
                }

                protected void useReadValue(@NotNull String localName) {
                    Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                    Object[] objectArray = new Object[]{this.$fieldName, localName};
                    this.$recv.addStatement("$N = $N", objectArray);
                }
            }.generate();
            recv.endControlFlow();
            recv.addStatement("break", new Object[0]);
        }
        type = new Object[]{TypeNames.INSTANCE.getPROTO_UTIL()};
        recv.addStatement("default: $T.skip(protocol, field.typeId); break", (Object[])type);
        recv.endControlFlow();
        recv.addStatement("protocol.readFieldEnd()", new Object[0]);
        recv.endControlFlow();
        recv.addStatement("protocol.readStructEnd()", new Object[0]);
        boolean isInControlFlow = false;
        if (hasReturnType) {
            recv.beginControlFlow("if (result != null)", new Object[0]);
            recv.addStatement("return result", new Object[0]);
            isInControlFlow = true;
        }
        for (Field field : method.getExceptions()) {
            String fieldName2 = this.fieldNamer.getName(field);
            if (isInControlFlow) {
                objectArray = new Object[]{fieldName2};
                recv.nextControlFlow("else if ($L != null)", objectArray);
            } else {
                objectArray = new Object[]{fieldName2};
                recv.beginControlFlow("if ($L != null)", objectArray);
                isInControlFlow = true;
            }
            objectArray = new Object[]{fieldName2};
            recv.addStatement("throw $L", objectArray);
        }
        if (isInControlFlow) {
            recv.nextControlFlow("else", new Object[0]);
        }
        if (hasReturnType) {
            object = new Object[]{TypeNames.INSTANCE.getTHRIFT_EXCEPTION(), TypeNames.INSTANCE.getTHRIFT_EXCEPTION_KIND(), ThriftException.Kind.MISSING_RESULT.name(), "Missing result"};
            recv.addStatement("throw new $T($T.$L, $S)", (Object[])object);
        } else {
            recv.addStatement("return kotlin.Unit.INSTANCE", new Object[0]);
        }
        if (isInControlFlow) {
            recv.endControlFlow();
        }
        MethodSpec methodSpec = recv.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"recv.build()");
        return methodSpec;
    }
}

