/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBuilder {
    private final String mToken;

    public MessageBuilder(String token) {
        this.mToken = token;
    }

    public JSONObject event(String distinctId, String eventName, JSONObject properties) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            JSONObject dataObj = new JSONObject();
            dataObj.put("event", (Object)eventName);
            JSONObject propertiesObj = null;
            propertiesObj = properties == null ? new JSONObject() : new JSONObject(properties.toString());
            if (!propertiesObj.has("token")) {
                propertiesObj.put("token", (Object)this.mToken);
            }
            if (!propertiesObj.has("time")) {
                propertiesObj.put("time", time);
            }
            if (distinctId != null) {
                propertiesObj.put("distinct_id", (Object)distinctId);
            }
            dataObj.put("properties", (Object)propertiesObj);
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"event");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }

    public JSONObject set(String distinctId, JSONObject properties) {
        return this.stdPeopleMessage(distinctId, "$set", properties);
    }

    public JSONObject increment(String distinctId, Map<String, Long> properties) {
        JSONObject jsonProperties = new JSONObject(properties);
        return this.stdPeopleMessage(distinctId, "$add", jsonProperties);
    }

    private JSONObject stdPeopleMessage(String distinctId, String actionType, JSONObject properties) {
        try {
            JSONObject dataObj = new JSONObject();
            dataObj.put(actionType, (Object)properties);
            dataObj.put("$token", (Object)this.mToken);
            dataObj.put("$distinct_id", (Object)distinctId);
            dataObj.put("$time", System.currentTimeMillis());
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"people");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }
}

