/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.config;

public class BaseFlagsConfig {
    private final String projectToken;
    private final String apiHost;
    private final int requestTimeoutSeconds;

    protected BaseFlagsConfig(String projectToken, String apiHost, int requestTimeoutSeconds) {
        this.projectToken = projectToken;
        this.apiHost = apiHost;
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    public String getProjectToken() {
        return this.projectToken;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public int getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected String projectToken;
        protected String apiHost = "api.mixpanel.com";
        protected int requestTimeoutSeconds = 10;

        public T projectToken(String projectToken) {
            this.projectToken = projectToken;
            return (T)this;
        }

        public T apiHost(String apiHost) {
            this.apiHost = apiHost;
            return (T)this;
        }

        public T requestTimeoutSeconds(int requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return (T)this;
        }

        public BaseFlagsConfig build() {
            return new BaseFlagsConfig(this.projectToken, this.apiHost, this.requestTimeoutSeconds);
        }
    }
}

