/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.util;

import java.nio.charset.StandardCharsets;

public final class HashUtils {
    private static final long FNV_OFFSET_BASIS_64 = -3750763034362895579L;
    private static final long FNV_PRIME_64 = 1099511628211L;

    private HashUtils() {
        throw new AssertionError((Object)"HashUtils should not be instantiated");
    }

    public static float normalizedHash(String key, String salt) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (salt == null) {
            throw new IllegalArgumentException("Salt cannot be null");
        }
        String combined = key + salt;
        byte[] bytes = combined.getBytes(StandardCharsets.UTF_8);
        long hash = -3750763034362895579L;
        for (byte b : bytes) {
            hash ^= (long)(b & 0xFF);
            hash *= 1099511628211L;
        }
        return (float)((double)Long.remainderUnsigned(hash, 100L) / 100.0);
    }

    public static float rolloutHash(String input) {
        return HashUtils.normalizedHash(input, "rollout");
    }

    public static float variantHash(String input) {
        return HashUtils.normalizedHash(input, "variant");
    }
}

