/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.util;

import com.mixpanel.mixpanelapi.featureflags.util.JsonCaseDesensitizer;
import io.github.jamsesso.jsonlogic.JsonLogic;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JsonLogicEngine {
    private static final Logger logger = Logger.getLogger(JsonLogicEngine.class.getName());
    private static final JsonLogic jsonLogic = new JsonLogic();

    public static boolean evaluate(JSONObject rule, Map<String, Object> data) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        Map lowercasedData = (Map)JsonCaseDesensitizer.lowercaseAllNodes(data);
        try {
            String ruleJson = JsonCaseDesensitizer.lowercaseLeafNodes(rule).toString();
            logger.log(Level.FINE, () -> "Evaluating JsonLogic rule: " + ruleJson + " with data: " + lowercasedData.toString());
            Object result = jsonLogic.apply(ruleJson, (Object)lowercasedData);
            return JsonLogic.truthy((Object)result);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error evaluating runtime rule", e);
            return false;
        }
    }
}

