/*
 * Decompiled with CFR 0.152.
 */
package com.monadiccloud.bindingz.contract.registry.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.monadiccloud.bindingz.contract.registry.client.configuration.SourceCodeConfiguration;
import com.monadiccloud.bindingz.contract.registry.client.model.ContractDto;
import com.monadiccloud.bindingz.contract.registry.client.model.ContractResource;
import com.monadiccloud.bindingz.contract.registry.client.model.SourceResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class ContractRegistryClient {
    private final String registryString;
    private final String apiKey;
    private ObjectMapper mapper = new ObjectMapper();

    public ContractRegistryClient(String registryString, String apiKey) {
        this.registryString = registryString;
        this.apiKey = apiKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContractResource publishContract(ContractDto schemaDto) {
        String url = String.format("%s/api/v1/schemas/%s/%s/%s?version=%s", this.registryString, schemaDto.getNamespace(), schemaDto.getOwner(), schemaDto.getContractName(), schemaDto.getVersion());
        try {
            HttpURLConnection post = (HttpURLConnection)new URL(url).openConnection();
            post.setDoOutput(true);
            post.setRequestProperty("Content-Type", "application/json");
            post.setRequestProperty("Authorization", this.apiKey);
            post.setRequestMethod("POST");
            post.connect();
            String body = this.mapper.writeValueAsString((Object)schemaDto.getSchema());
            post.getOutputStream().write(body.getBytes("UTF-8"));
            int responseCode = post.getResponseCode();
            System.out.println("\nSending 'POST' request to URL : " + url);
            System.out.println("Response Code : " + responseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(post.getInputStream()));){
                StringBuilder response = new StringBuilder();
                String line = null;
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                ContractResource contractResource = (ContractResource)this.mapper.readValue(response.toString(), ContractResource.class);
                return contractResource;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceResource generateSources(String namespace, String owner, String contractName, String version, SourceCodeConfiguration configuration) {
        String url = String.format("%s/api/v1/sources/%s/%s/%s?version=%s", this.registryString, namespace, owner, contractName, version);
        try {
            HttpURLConnection post = (HttpURLConnection)new URL(url).openConnection();
            post.setDoOutput(true);
            post.setRequestProperty("Content-Type", "application/json");
            post.setRequestProperty("Authorization", this.apiKey);
            post.setRequestMethod("POST");
            post.connect();
            String body = this.mapper.writeValueAsString((Object)configuration);
            post.getOutputStream().write(body.getBytes("UTF-8"));
            int responseCode = post.getResponseCode();
            System.out.println("\nSending 'POST' request to URL : " + url);
            System.out.println("Response Code : " + responseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(post.getInputStream()));){
                StringBuilder response = new StringBuilder();
                String line = null;
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                SourceResource sourceResource = (SourceResource)this.mapper.readValue(response.toString(), SourceResource.class);
                return sourceResource;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

