package com.morphcloud.api;

import com.morphcloud.navigator.client.Client;
import com.morphcloud.navigator.entity.EntitySearchResultItem;
import com.morphcloud.navigator.node.Node;

import java.util.List;

class ApiFormSearchImpl implements ApiFormSearch {

    private final Client client;
    private final String path;
    private final String searchKey;

    ApiFormSearchImpl(ApiBase<?> base, String searchKey) {
        this.client = base.getClient();
        this.path = base.getPath();
        this.searchKey = searchKey;
    }

    @Override
    public List<EntitySearchResultItem> get(String searchValue) {
        try {
            Node<EntitySearchResultItem> node = client.<EntitySearchResultItem>request(path).addSearch(searchKey, searchValue).addContext().build().get();
            return node.getData().setClass(EntitySearchResultItem.class).getPage().orElseThrow().getContent();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
