package com.morphcloud.api;

import com.morphcloud.navigator.entity.Entity;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class ApiIterator<E extends Entity, W> implements Iterator<W> {

    private final List<E> list;
    private final Function<E, W> fn;
    private int pos;

    public ApiIterator(List<E> list, Function<E, W> fn) {
        this.list = list;
        this.fn = fn;
    }


    @Override
    public boolean hasNext() {
        return (pos < list.size());
    }

    @Override
    public W next() {
        return fn.apply(list.get(pos++));
    }
}
