package com.morphcloud.api;

import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.navigator.entity.EntityTransform;

import java.util.Comparator;

public interface ApiTransformEntity extends ApiEntity<EntityTransform> {
    ApiTransformLoadResource load();
    long headerMatches(Class<?> cls);
    ApiTransformHeaderResource header();

    static Comparator<ApiTransformEntity> headerMatchSort(Class<?> cls) {
        return (a, b) -> Math.toIntExact(a.headerMatches(cls) - b.headerMatches(cls));
    }

    ApiTransformHeaderEntity headerByNameSlug(String nameSlug);

    <D extends Entity> ApiTransformDestinationResource<D> destination(Class<D> cls);
}