package com.morphcloud.api;

import com.morphcloud.navigator.entity.EntityTransformError;
import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;

import java.util.Optional;

class ApiTransformErrorImpl implements ApiTransformError {

    private final ApiTransformHeaderEntityImpl owner;

    ApiTransformErrorImpl(ApiTransformHeaderEntityImpl owner) {
        this.owner = owner;
    }

    @Override
    public ApiTransformErrorResource getPage(int pageSize) {
        return new ApiTransformErrorResourceImpl(owner, QueryParameterBuilder.size(pageSize));
    }

    @Override
    public Optional<ApiTransformErrorEntity> getErrorByRowId(int rowId) {
        return new ApiTransformErrorResourceImpl(owner, QueryParameterBuilder.newInstance(QueryParameter.filter_dyn).addDynamicKeyPart("sheetRowIndex").addValue(rowId).build())
                .getData().getPage().orElseThrow().getContent().stream().findFirst().map(entity -> new ApiTransformErrorEntityImpl(owner, entity, EntityTransformError.class));
    }
}
