package com.morphcloud.api;

import com.morphcloud.navigator.entity.EntityTransformHeader;
import com.morphcloud.navigator.node.NodeKey;
import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;

import java.util.List;

class ApiTransformHeaderResourceImpl extends ApiBaseResource<EntityTransformHeader> implements ApiTransformHeaderResource {
    ApiTransformHeaderResourceImpl(ApiBase<?> base) {
        super(base, NodeKey.header, EntityTransformHeader.class, QueryParameterBuilder.sizeAll());
    }

    ApiTransformHeaderResourceImpl(ApiBase<?> base, String nameSlug) {
        super(base, NodeKey.header, EntityTransformHeader.class, QueryParameterBuilder.newInstance(QueryParameter.filter_dyn).addDynamicKeyPart("destinationColumnNameSlug").addValue(nameSlug).build());
    }

    @Override
    public List<EntityTransformHeader> all() {
        return getData().getPage().orElseThrow().getContent();
    }
}
