package com.morphcloud.api;

import com.morphcloud.api.request.RequestNewTransform;
import com.morphcloud.navigator.entity.EntitySearchResultItem;
import com.morphcloud.navigator.entity.EntityTransform;
import com.morphcloud.navigator.node.NodeKey;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ApiTransformResourceImpl extends ApiBaseResource<EntityTransform> implements ApiTransformResource {
    ApiTransformResourceImpl(ApiBase<?> base) {
        super(base, NodeKey.transform, EntityTransform.class);
    }

    @Override
    public List<ApiTransformEntity> getOrCreateAll() {
        List<EntityTransform> all = new ArrayList<>();
        List<EntitySearchResultItem> tableKeys = getFormSearch("table").get("");
        Function<EntitySearchResultItem, Optional<EntityTransform>> existingFinder = existingFinder();
        for (EntitySearchResultItem tableKey :tableKeys) {
            Optional<EntityTransform> existingOpt = existingFinder.apply(tableKey);
            all.add(existingOpt.orElseGet(create(tableKey)));
        }
        return all.stream().map(this::toWorkflow).collect(Collectors.toList());
    }

    private ApiTransformEntity toWorkflow(EntityTransform transform) {
        return new ApiTransformEntityImpl(this, transform);
    }

    private Supplier<EntityTransform> create(EntitySearchResultItem tableKey) {
        return () -> post(new RequestNewTransform(tableKey.getKey(), tableKey.getKey()));
    }

    private Function<EntitySearchResultItem, Optional<EntityTransform>> existingFinder() {
        List<EntityTransform> existing = getData().getPage().orElseThrow().getContent();
        return tableKey -> existing.stream().filter(transform -> tableKey.getKey().startsWith(transform.getName())).findFirst();
    }
}