package com.morphcloud.api;

import com.morphcloud.navigator.client.Client;
import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.navigator.entity.EntityVersion;
import com.morphcloud.navigator.node.NodeKey;
import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;
import org.apache.hc.core5.http.NameValuePair;

import java.util.ArrayList;
import java.util.List;

class ApiVersionEntityImpl extends ApiBase<EntityVersion> implements ApiVersionEntity {
    ApiVersionEntityImpl(Client client, String path) {
        super(client, path, EntityVersion.class);
        requireContext(NodeKey.version);
        requireResource(NodeKey.row);
    }

    @Override
    public <E extends Entity> ApiRowResource<E> row(Class<E> cls) {
        return new ApiRowResourceImpl<>(this, cls);
    }

    @Override
    public <E extends Entity> ApiRowResource<E> row(Class<E> cls, String filterFieldNameCamel, Object filterValue) {
        return new ApiRowResourceImpl<>(this, cls, List.of(QueryParameterBuilder.newInstance(QueryParameter.filter_dyn).addDynamicKeyPart(filterFieldNameCamel).addValue(filterValue).build()));
    }

    @Override
    public <E extends Entity> ApiRowResource<E> rowAll(Class<E> cls, String filterFieldNameCamel, Object filterValue) {
        List<NameValuePair> params = new ArrayList<>();
        params.add(QueryParameterBuilder.newInstance(QueryParameter.filter_dyn).addDynamicKeyPart(filterFieldNameCamel).addValue(filterValue).build());
        params.add(QueryParameterBuilder.sizeAll());
        return new ApiRowResourceImpl<>(this, cls, params);
    }
}