package com.morphcloud.api;

import com.morphcloud.api.entity.EntityExtractSheet;
import com.morphcloud.navigator.node.NodeKey;

import java.util.Iterator;
import java.util.List;

class ApiSheetResourceImpl extends ApiBaseResource<EntityExtractSheet> implements ApiSheetResource {
    ApiSheetResourceImpl(ApiBase<?> base) {
        super(base, NodeKey.sheet, EntityExtractSheet.class);
    }

    @Override
    public Iterator<ApiSheetEntity> iterate() {
        return new ApiIterator<>(getContent(), this::toWorkflow);
    }

    private List<EntityExtractSheet> getContent() {
        return super.getData().getPage().orElseThrow().getContent();
    }

    private ApiSheetEntity toWorkflow(EntityExtractSheet sheet) {
        return new ApiSheetEntityImpl(this, sheet);
    }
}
