package com.morphcloud.api.request;

import com.morphcloud.http.HttpBodyBase;

public class RequestNewTransform extends HttpBodyBase<RequestNewTransform> {

    private final String name;
    private final String tablePath;

    public RequestNewTransform(String name, String tablePath) {
        super(RequestNewTransform.class);
        this.name = (name.length() > 50) ? name.substring(0, 50) : name;
        this.tablePath = tablePath;
    }

    public String getName() {
        return name;
    }

    public String getTablePath() {
        return tablePath;
    }
}
