package com.morphcloud.api;

import com.morphcloud.navigator.node.NodeAction;
import com.morphcloud.navigator.node.NodeControlResource;

public class ApiAuthException extends RuntimeException {
    ApiAuthException(NodeControlResource resource) {
        super(String.format("Not authorized to access resource: %s", resource.getLinkTo()));
    }

    ApiAuthException(NodeAction action) {
        super(action.getAuth().getMessage().orElse("Action denied"));
    }

    ApiAuthException(String message) {
        super(message);
    }
}
