package com.morphcloud.api;

import com.morphcloud.navigator.entity.Entity;

class ApiBaseEntity<E extends Entity> extends ApiBase<E> implements ApiEntity<E> {
    ApiBaseEntity(ApiBase<?> base, E entity, Class<E> cls) {
        super(base, entity.getLinkTo(), cls);
    }

    ApiBaseEntity(ApiBase<?> base, String linkTo, Class<E> cls) {
        super(base, linkTo, cls);
    }

    @Override
    public E getEntity() {
        return getData().getEntity().orElseThrow();
    }
}