package com.morphcloud.api;

import com.morphcloud.navigator.node.NodeKey;
import org.apache.hc.core5.http.NameValuePair;

import java.util.List;

class ApiBaseResource<E> extends ApiBase<E> {

    ApiBaseResource(ApiBase<?> base, NodeKey resourceKey, Class<E> cls) {
        super(base, base.getAuthorizedResource(resourceKey).getLinkTo(), cls);
    }

    ApiBaseResource(ApiBase<?> base, NodeKey resourceKey, Class<E> cls, NameValuePair queryParam) {
        super(base, base.getAuthorizedResource(resourceKey).getLinkTo(), cls, queryParam);
    }

    ApiBaseResource(ApiBase<?> base, NodeKey resourceKey, Class<E> cls, List<NameValuePair> queryParam) {
        super(base, base.getAuthorizedResource(resourceKey).getLinkTo(), cls, queryParam);
    }

    protected ApiFormSearch getFormSearch(String searchKey) {
        return new ApiFormSearchImpl(this, searchKey);
    }
}