package com.morphcloud.api;

import com.morphcloud.api.entity.EntityCell;
import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.navigator.node.NodeKey;

import java.util.Optional;

class ApiRowEntityImpl<E extends Entity> extends ApiBaseEntity<E> implements ApiRowEntity<E> {

    ApiRowEntityImpl(ApiBase<?> base, E entity, Class<E> cls) {
        super(base, entity, cls);
        requireResource(NodeKey.cell);
    }

    @Override
    public ApiCellResource cell() {
        return new ApiCellResourceImpl(this);
    }

    @Override
    public Optional<ApiCellEntity> cell(String cellName) {
        Optional<EntityCell> opt = new ApiCellResourceImpl(this).getData().getPage().orElseThrow().getContent().stream().filter(cell -> cell.getName().equals(cellName)).findFirst();
        return (opt.isPresent()) ? Optional.of(new ApiCellEntityImpl(this, opt.get())) : Optional.empty();
    }
}
