package com.morphcloud.api;

import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.http.HttpBody;
import com.morphcloud.navigator.node.NodeKey;
import org.apache.hc.core5.http.NameValuePair;

import java.util.List;
import java.util.Optional;

class ApiRowResourceImpl<E extends Entity> extends ApiBaseResource<E> implements ApiRowResource<E> {

    ApiRowResourceImpl(ApiBase<?> base, Class<E> cls) {
        super(base, NodeKey.row, cls);
        requireContext(NodeKey.version);
    }

    ApiRowResourceImpl(ApiBase<?> base, Class<E> cls, List<NameValuePair> queryParam) {
        super(base, NodeKey.row, cls, queryParam);
        requireContext(NodeKey.version);
    }

    @Override
    public <B extends HttpBody<B>> ApiRowEntity<E> create(B newRow) {
        return get(super.post(newRow));
    }

    @Override
    public Optional<ApiRowEntity<E>> getFirst() {
        Optional<E> opt = super.getData().getPageFirst();
        return (opt.isPresent()) ? Optional.of(get(opt.get())) : Optional.empty();
    }

    @Override
    public List<E> getAllData() {
        return getData().getPage().orElseThrow().getContent();
    }

    private ApiRowEntity<E> get(E entity) {
        return new ApiRowEntityImpl<>(this, entity, super.getCls());
    }
}
