package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransform;
import com.morphcloud.navigator.entity.Entity;

import java.util.Comparator;

public interface ApiTransformEntity extends ApiEntity<EntityTransform> {
    ApiTransformLoadResource load();
    long headerMatches(Class<?> cls);
    ApiTransformHeaderResource header();

    static Comparator<ApiTransformEntity> headerMatchSort(Class<?> cls) {
        return (a, b) -> Math.toIntExact(a.headerMatches(cls) - b.headerMatches(cls));
    }

    ApiTransformOutput output();

    ApiTransformError error();

    ApiTransformExclude exclude();

    ApiTransformHeaderEntity headerByNameSlug(String nameSlug);

    <D extends Entity> ApiTransformDestinationResource<D> destination(Class<D> cls);
}