package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransform;
import com.morphcloud.api.entity.EntityTransformDestination;
import com.morphcloud.api.entity.EntityTransformHeader;
import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.navigator.node.NodeKey;

import java.util.Set;
import java.util.stream.Collectors;

class ApiTransformEntityImpl extends ApiBaseEntity<EntityTransform> implements ApiTransformEntity {

    private final EntityTransform transform;
    private ApiTransformHeaderResource header = null;

    ApiTransformEntityImpl(ApiBase<?> base, EntityTransform transform) {
        super(base, transform, EntityTransform.class);
        this.transform = transform;
    }

    @Override
    public ApiTransformLoadResource load() {
        return new ApiTransformLoadResourceImpl(this);
    }

    @Override
    public long headerMatches(Class<?> cls) {
        Set<String> destinationFields = getDestinationFields();
        for (String clsField : Entity.getFields(cls)) if (!destinationFields.contains(clsField)) return 0;
        return header().all().stream().filter(header -> header.getExtractColumn() != null).count();
    }

    @Override
    public ApiTransformHeaderResource header() {
        if (header == null) header = new ApiTransformHeaderResourceImpl(this);
        return header;
    }

    @Override
    public ApiTransformOutput output() {
        return new ApiTransformOutputImpl(this);
    }

    @Override
    public ApiTransformError error() {
        return new ApiTransformErrorImpl(this);
    }

    @Override
    public ApiTransformExclude exclude() {
        return new ApiTransformExcludeImpl(this, this.transform);
    }

    @Override
    public ApiTransformHeaderEntity headerByNameSlug(String nameSlug) {
        EntityTransformHeader header = new ApiTransformHeaderResourceImpl(this, nameSlug).all().stream().findFirst().orElseThrow();
        return new ApiTransformHeaderEntityImpl(this, header);
    }

    @Override
    public <D extends Entity> ApiTransformDestinationResource destination(Class<D> cls) {
        EntityTransformDestination destination = new ApiBaseResource<>(this, NodeKey.destination, EntityTransformDestination.class).getData().getEntity().orElseThrow();
        return new ApiTransformDestinationResourceImpl<>(this, destination, cls);
    }

    private Set<String> getDestinationFields() {
        return header().all().stream().map(EntityTransformHeader::getDestinationColumnNameCamel).collect(Collectors.toSet());
    }
}