package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransformError;
import com.morphcloud.api.request.RequestUpdateTransformError;

public class ApiTransformErrorEntityImpl extends ApiBaseEntity<EntityTransformError> implements ApiTransformErrorEntity {
    ApiTransformErrorEntityImpl(ApiBase<?> base, EntityTransformError entity) {
        super(base, entity, EntityTransformError.class);
    }

    ApiTransformErrorEntityImpl(ApiBase<?> base, String path) {
        super(base, path, EntityTransformError.class);
    }

    @Override
    public EntityTransformError fixValue(Object fixValue, Boolean saveAsMap) {
        return super.patch(new RequestUpdateTransformError(fixValue, saveAsMap));
    }
}