package com.morphcloud.api;

import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;
import org.apache.hc.core5.http.NameValuePair;

import java.util.Optional;
import java.util.function.BiFunction;


class ApiTransformErrorImpl implements ApiTransformError {

    private final ApiBase<?> owner;
    private final Optional<BiFunction<String, Integer, String>> buildErrorLinkToOpt;

    ApiTransformErrorImpl(ApiTransformHeaderEntityImpl owner) {
        this.owner = owner;
        this.buildErrorLinkToOpt = Optional.empty();
    }

    ApiTransformErrorImpl(ApiTransformEntityImpl owner) {
        this.owner = owner;
        this.buildErrorLinkToOpt = Optional.of((String columnNameSlug, Integer rowId) -> String.format("%s/header/%s/error/%s", owner.getEntity().getLinkTo(), columnNameSlug, rowId));
    }

    @Override
    public ApiTransformErrorResource getPage(int page, int size) {
        return new ApiTransformErrorResourceImpl(owner, QueryParameterBuilder.paginate(page, size));
    }

    @Override
    public Optional<ApiTransformErrorEntity> getErrorByRowId(int rowId) {
        NameValuePair query = QueryParameterBuilder.newInstance(QueryParameter.filter_dyn).addDynamicKeyPart("sheetRowIndex").addValue(rowId).build();
        return new ApiTransformErrorResourceImpl(owner, query)
                .getData().getPage().orElseThrow().getContent().stream().findFirst().map(entity -> new ApiTransformErrorEntityImpl(owner, entity));
    }

    @Override
    public Optional<ApiTransformErrorEntity> getErrorByColumnNameSlugAndRowId(String columnNameSlug, int rowId) {
        try {
            return Optional.of(new ApiTransformErrorEntityImpl(owner, buildErrorLinkToOpt.orElseThrow().apply(columnNameSlug, rowId)));
        } catch (Exception e) {
            return Optional.empty();
        }
    }
}