package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransform;
import com.morphcloud.api.entity.EntityTransformExclude;

import java.util.List;
import java.util.Optional;

class ApiTransformExcludeImpl implements ApiTransformExclude {

    private final ApiBase<?> base;
    private final EntityTransform transform;

    ApiTransformExcludeImpl(ApiBase<?> base, EntityTransform transform) {
        this.base = base;
        this.transform = transform;
    }

    @Override
    public List<EntityTransformExclude> getAll() {
        return new ApiTransformExcludeResourceImpl(base, -1).getList();
    }

    @Override
    public EntityTransformExclude create(Integer sheetRowIndex, Boolean excludeAllAfter) {
        return new ApiTransformExcludeResourceImpl(base, 0).create(sheetRowIndex, excludeAllAfter);
    }

    @Override
    public Optional<ApiTransformExcludeEntity> getForRow(Integer sheetRowIndex) {
        return Optional.of(new ApiTransformExcludeEntityImpl(base, transform, sheetRowIndex));
    }

}
