package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransformHeader;
import com.morphcloud.api.request.RequestUpdateTransformHeaderColumn;
import com.morphcloud.api.response.ResponseSearchResultItem;
import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;

import java.util.List;

class ApiTransformHeaderEntityImpl extends ApiBaseEntity<EntityTransformHeader> implements ApiTransformHeaderEntity {
    ApiTransformHeaderEntityImpl(ApiBase<?> base, EntityTransformHeader entity) {
        super(base, entity, EntityTransformHeader.class);
    }

    @Override
    public ApiTransformHeaderEntity setExtractHeader(RequestUpdateTransformHeaderColumn update) {
        return new ApiTransformHeaderEntityImpl(this, super.patch(update));
    }

    @Override
    public List<ResponseSearchResultItem> getHeaderOptions(String search, int size) {
            return super.getUpdate(ResponseSearchResultItem.class,
                List.of(
                    QueryParameterBuilder.newInstance(QueryParameter.size).addValue(size).build(),
                    QueryParameterBuilder.newInstance(QueryParameter.formSearch_dyn).addDynamicKeyPart("column").addValue(search).build()
                )
            ).getData().setClass(ResponseSearchResultItem.class).getPage().orElseThrow().getContent();
    }

    @Override
    public ApiTransformError error() {
        return new ApiTransformErrorImpl(this);
    }
}
