package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransformLoad;
import com.morphcloud.api.request.RequestNewTransformLoad;
import com.morphcloud.navigator.node.NodeAction;
import com.morphcloud.navigator.node.NodeActionType;
import com.morphcloud.navigator.node.NodeKey;

import java.util.Optional;

class ApiTransformLoadResourceImpl extends ApiBaseResource<EntityTransformLoad> implements ApiTransformLoadResource {
    ApiTransformLoadResourceImpl(ApiBase<?> base) {
        super(base, NodeKey.load, EntityTransformLoad.class);
    }

    @Override
    public EntityTransformLoad load() {
        runAuth();
        return super.post(new RequestNewTransformLoad());
    }

    @Override
    public boolean isLoadable() {
        return getAction(NodeActionType.post).map(action -> action.getAuth().getAuthorized()).orElse(false);
    }

    public boolean isLoadable(Optional<NodeAction> actionOpt) {
        return actionOpt.map(action -> action.getAuth().getAuthorized()).orElse(false);
    }

    public void runAuth() {
        Optional<NodeAction> actionOpt = getAction(NodeActionType.post);
        if (!isLoadable(actionOpt)) {
            if (actionOpt.isPresent()) {
                throw new ApiAuthException(actionOpt.get());
            } else {
                throw new ApiAuthException("Authorization denied.");
            }
        }
    }
}