package com.morphcloud.api;

import com.morphcloud.api.entity.EntityExtract;
import com.morphcloud.api.request.RequestNewExtract;
import com.morphcloud.navigator.node.NodeKey;

import java.util.Optional;

class ApiExtractResourceImpl extends ApiBaseResource<EntityExtract> implements ApiExtractResource {
    ApiExtractResourceImpl(ApiBase<?> base) {
        super(base, NodeKey.extract, EntityExtract.class);
    }

    @Override
    public Optional<ApiExtractEntity> getFirst() {
        EntityExtract extract = super.getData().getPageFirst().orElseGet(this::createExtract);
        return Optional.of(new ApiExtractEntityImpl(this, extract));
    }

    EntityExtract createExtract() {
        return super.post(new RequestNewExtract());
    }
}
