package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransformDestination;
import com.morphcloud.navigator.entity.Entity;
import com.morphcloud.navigator.query.QueryParameter;
import com.morphcloud.navigator.query.QueryParameterBuilder;
import org.apache.hc.core5.http.NameValuePair;

import java.util.ArrayList;
import java.util.List;

class ApiTransformDestinationResourceImpl<E extends Entity> extends ApiBase<E> implements ApiTransformDestinationResource<E> {
    ApiTransformDestinationResourceImpl(ApiBase<?> base, EntityTransformDestination entity, Class<E> cls) {
        super(base, entity.getLinkTo(), cls, params(entity.getLinkTo()));
    }

    @Override
    public List<E> getCompleteData() {
        return getData().getPage().orElseThrow().getContent();
    }

    private static List<NameValuePair> params(String path) {
        List<NameValuePair> params = new ArrayList<>(2);
        params.add(QueryParameterBuilder.sizeAll());
        QueryParameter.filter_dyn.findFirst(path).ifPresent(params::add);
        return params;
    }
}
